﻿using FluentValidation;

namespace QualityManagement.MediatR;
public class AddSupplierQualificationCommandValidator : AbstractValidator<AddSupplierQualificationCommand>
{
    public AddSupplierQualificationCommandValidator()
    {
        RuleFor(c => c.SupplierId)
             .NotEmpty()
             .WithMessage("SupplierId is required and cannot be empty.");
        RuleFor(c => c.QualifiedById)
            .NotEmpty()
            .WithMessage("QualifiedById is required and cannot be empty.");
        RuleFor(c => c.QualificationDate)
            .NotEmpty()
            .WithMessage("QualificationDate is required and cannot be empty.");
        RuleFor(c => c.Criteria)
            .NotEmpty()
            .WithMessage("Criteria is required and cannot be empty.");
        RuleFor(c => c.Result)
            .NotEmpty()
            .WithMessage("Result is required and cannot be empty.");
        RuleFor(c => c.Remarks)
            .NotEmpty()
            .WithMessage("Remarks is required and cannot be empty.");

    }
}
