﻿using MediatR;
using QualityManagement.Data.Dto;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class MarkAllAsReadHandler(
        IUserNotificationRepository _userNotificationRepository) : IRequestHandler<MarkAllAsReadCommand, UserNotificationDto>
    {
        public async Task<UserNotificationDto> Handle(MarkAllAsReadCommand request, CancellationToken cancellationToken)
        {
            await _userNotificationRepository.MarkAllAsRead();
            return new UserNotificationDto();
        }

    }
}
