﻿using MediatR;
using QualityManagement.Data.Dto;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class MarkAsReadHandler(
        IUserNotificationRepository _userNotificationRepository) : IRequestHandler<MarkAsReadCommand, UserNotificationDto>
    {
        public async Task<UserNotificationDto> Handle(MarkAsReadCommand request, CancellationToken cancellationToken)
        {
            await _userNotificationRepository.MarkAsRead(request.Id);
            return new UserNotificationDto();
        }

    }
}
