﻿using AutoMapper;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;
public class AddUserOpenaiMsgCommandHandler(
    IUserOpenaiMsgRepository userOpenaiMsgRepository,
    IMapper mapper,
    IUnitOfWork<QMSDbContext> uow) : IRequestHandler<AddUserOpenaiMsgCommand, ServiceResponse<UserOpenaiMsgDto>>
{


    public async Task<ServiceResponse<UserOpenaiMsgDto>> Handle(AddUserOpenaiMsgCommand request, CancellationToken cancellationToken)
    {
        var userOpenaiMsg = new UserOpenaiMsg
        {
            Title = request.Title,
            PromptInput = request.PromptInput,
            Language = request.Language,
            MaximumLength = request.MaximumLength,
            Creativity = request.Creativity,
            ToneOfVoice = request.ToneOfVoice,
            SelectedModel = request.SelectedModel
        };

        userOpenaiMsgRepository.Add(userOpenaiMsg);

        if (await uow.SaveAsync() <= 0)
        {
            return ServiceResponse<UserOpenaiMsgDto>.Return500();
        }
        var entityDto = mapper.Map<UserOpenaiMsgDto>(userOpenaiMsg);
        return ServiceResponse<UserOpenaiMsgDto>.ReturnResultWith201(entityDto);

    }
}


