﻿using QualityManagement.Common.UnitOfWork;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;
public class DeleteUserOpenaiMsgCommandHandler(
    IUserOpenaiMsgRepository _userOpenaiMsgRepository,
    IUnitOfWork<QMSDbContext> _uow
    ) : IRequestHandler<DeleteUserOpenaiMsgCommand, ServiceResponse<bool>>
{
    public async Task<ServiceResponse<bool>> Handle(DeleteUserOpenaiMsgCommand request, CancellationToken cancellationToken)
    {
        var userOpenaiMsg = await _userOpenaiMsgRepository.FindAsync(request.Id);
        if (userOpenaiMsg == null)
        {
            return ServiceResponse<bool>.Return404();
        }
        _userOpenaiMsgRepository.Remove(userOpenaiMsg);
        if (await _uow.SaveAsync() <= 0)
        {
            return ServiceResponse<bool>.Return500();
        }
        return ServiceResponse<bool>.ReturnResultWith200(true);
    }
}
