﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Repository;
using MediatR;
using Microsoft.EntityFrameworkCore;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetAllUserQueryHandler(
       IUserRepository userRepository,
       IMapper mapper
        ) : IRequestHandler<GetAllUserQuery, List<UserDto>>
    {
        public async Task<List<UserDto>> Handle(GetAllUserQuery request, CancellationToken cancellationToken)
        {
            var entities = await userRepository.All.ToListAsync(cancellationToken);
            return mapper.Map<List<UserDto>>(entities);
        }
    }
}
