﻿using QualityManagement.Data.Dto;
using QualityManagement.Repository;
using MediatR;
using Microsoft.EntityFrameworkCore;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetUsersForDropdownQueryHandler(
        IUserRepository userRepository) : IRequestHandler<GetUsersForDropdownQuery, List<UserDto>>
    {
        public async Task<List<UserDto>> Handle(GetUsersForDropdownQuery request, CancellationToken cancellationToken)
        {
            var users = await userRepository.All.Select(c => new UserDto
            {
                Id = c.Id,
                Email = c.Email,
                FirstName = c.FirstName,
                LastName = c.LastName,
                UserName = c.UserName
            }).ToListAsync();

            return users;
        }
    }
}
