﻿using AutoMapper;
using MediatR;
using Microsoft.AspNetCore.Identity;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.Domain;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class UpdateUserProfileCommandHandler(
        UserManager<User> _userManager,
        IUnitOfWork<QMSDbContext> _uow,
        IMapper _mapper,
        UserInfoToken _userInfoToken) : IRequestHandler<UpdateUserProfileCommand, UserDto>
    {
        public async Task<UserDto> Handle(UpdateUserProfileCommand request, CancellationToken cancellationToken)
        {
            var appUser = await _userManager.FindByIdAsync(_userInfoToken.Id.ToString());
            if (appUser == null)
            {
                var errorDto = new UserDto
                {
                    StatusCode = 409,
                    Messages = new List<string> { "User does not exist." }
                };
                return errorDto;
            }
            appUser.FirstName = request.FirstName;
            appUser.LastName = request.LastName;
            appUser.PhoneNumber = request.PhoneNumber;
            IdentityResult result = await _userManager.UpdateAsync(appUser);
            if (await _uow.SaveAsync() <= -1 && !result.Succeeded)
            {
                var errorDto = new UserDto
                {
                    StatusCode = 500,
                    Messages = new List<string> { "An unexpected fault happened. Try again later." }
                };
                return errorDto;
            }
            return _mapper.Map<UserDto>(appUser);
        }
    }

}
