﻿using MediatR;
using Microsoft.AspNetCore.Identity;
using Microsoft.AspNetCore.SignalR;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.Repository;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class UserLoginCommandHandler(
        IUserRepository _userRepository,
        UserManager<User> _userManager,
        ILoginAuditRepository _loginAuditRepository,
        IHubContext<UserHub, IHubClient> _hubContext) : IRequestHandler<UserLoginCommand, UserAuthDto>
    {
        public async Task<UserAuthDto> Handle(UserLoginCommand request, CancellationToken cancellationToken)
        {
            var loginAudit = new LoginAuditDto
            {
                UserName = request.UserName,
                RemoteIP = request.RemoteIp,
                Status = "Success",
                Latitude = request.Latitude,
                Longitude = request.Longitude
            };

            var user = await _userManager.FindByNameAsync(request.UserName);
            if (user == null || !await _userManager.CheckPasswordAsync(user, request.Password))
            {
                loginAudit.Status = "Error";
                await _loginAuditRepository.LoginAudit(loginAudit);
                return new UserAuthDto
                {
                    StatusCode = 401,
                    Messages = new List<string> { "UserName Or Password is InCorrect." }
                };
            }

            await _loginAuditRepository.LoginAudit(loginAudit);
            var authUser = await _userRepository.BuildUserAuthObject(user);
            var onlineUser = new SignlarUser
            {
                Email = authUser.Email,
                Id = authUser.Id
            };
            await _hubContext.Clients.All.Joined(onlineUser);
            return authUser;

        }
    }
}
