﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using Microsoft.EntityFrameworkCore;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetAllWorkflowCommandHandler(IWorkflowRepository _workflowRepository, IMapper _mapper) : IRequestHandler<GetAllWorkflowQuery, ServiceResponse<List<WorkflowDto>>>
    {
        public async Task<ServiceResponse<List<WorkflowDto>>> Handle(GetAllWorkflowQuery request, CancellationToken cancellationToken)
        {
            var entities = await _workflowRepository.All.OrderByDescending(c => c.CreatedDate).ToListAsync(cancellationToken);
            var dtos = _mapper.Map<List<WorkflowDto>>(entities);
            return ServiceResponse<List<WorkflowDto>>.ReturnResultWith200(dtos);
        }
    }
}
