﻿using System.Linq;
using System.Threading.Tasks;
using QualityManagement.Common.GenericRepository;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Data.Resources;
using QualityManagement.Domain;

namespace QualityManagement.Repository;

public class AuditTemplateRepository(
    IUnitOfWork<QMSDbContext> uow,
     IPropertyMappingService _propertyMappingService) : GenericRepository<AuditTemplate, QMSDbContext>(uow), IAuditTemplateRepository
{
    public async Task<AuditTemplateList> GetAuditTemplates(AuditTemplateResource auditTemplateResource)
    {

        var collectionBeforePaging = AllIncluding(c => c.Questions, c => c.Audits);

        collectionBeforePaging = collectionBeforePaging.ApplySort(auditTemplateResource.OrderBy,
            _propertyMappingService.GetPropertyMapping<AuditTemplateDto, AuditTemplate>());

        if (!string.IsNullOrWhiteSpace(auditTemplateResource.Name))
        {
            collectionBeforePaging = collectionBeforePaging
            .Where(c => c.Name.StartsWith(auditTemplateResource.Name));
        }
        if (auditTemplateResource.DepartmentId.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
          .Where(c => c.DepartmentId == auditTemplateResource.DepartmentId);
        }
        if (auditTemplateResource.AuditType != AUDIT_TYPE.ALL)
        {
            collectionBeforePaging = collectionBeforePaging
                .Where(c => c.AuditType == auditTemplateResource.AuditType);
        }

        var allAuditTemplateList = new AuditTemplateList();
        return await allAuditTemplateList.Create(
            collectionBeforePaging,
            auditTemplateResource.Skip,
            auditTemplateResource.PageSize);

    }
}
