﻿using System.Threading.Tasks;
using QualityManagement.Common.GenericRepository;
using QualityManagement.Data.Entities;
using QualityManagement.Data.Resources;

namespace QualityManagement.Repository;

public interface IAuditRepository : IGenericRepository<Audit>
{
    Task<string> GenerateAuditNumberAsync();
    Task<AuditList> GetAudits(AuditResource auditResource);
    Task<AuditList> GetAuditForReview(AuditResource auditResource);
}
