﻿using Microsoft.EntityFrameworkCore;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace QualityManagement.Repository
{
    public class ComplaintLogList : List<ComplaintLogDto>
    {
        public int Skip { get; private set; }
        public int TotalPages { get; private set; }
        public int PageSize { get; private set; }
        public int TotalCount { get; private set; }
        public ComplaintLogList()
        {

        }
        public ComplaintLogList(List<ComplaintLogDto> items, int count, int skip, int pageSize)
        {
            TotalCount = count;
            PageSize = pageSize;
            Skip = skip;
            TotalPages = (int)Math.Ceiling(count / (double)pageSize);
            AddRange(items);
        }
        public async Task<ComplaintLogList> Create(IQueryable<ComplaintLog> source, int skip, int pageSize)
        {
            var count = await GetCount(source);
            var dtoList = await GetDtos(source, skip, pageSize);
            var dtoPageList = new ComplaintLogList(dtoList, count, skip, pageSize);
            return dtoPageList;
        }
        public async Task<int> GetCount(IQueryable<ComplaintLog> source)
        {
            return await source.AsNoTracking().CountAsync();
        }
        public async Task<List<ComplaintLogDto>> GetDtos(IQueryable<ComplaintLog> source, int skip, int pageSize)
        {
            try
            {
                var risk = await source
                    .Skip(skip)
                    .Take(pageSize)
                    .AsNoTracking()
                    .Select(c => new ComplaintLogDto
                    {
                        Id = c.Id,
                        ComplaintId = c.ComplaintId,
                        Title = c.Title,
                        Description = c.Description,
                        LogStatus = c.LogStatus,
                        Status = c.Status,
                        Priority = c.Priority,
                        ComplaintNo = c.ComplaintNo,
                        ReportedBy = c.ReportedBy,
                        ResolutionSummary = c.ResolutionSummary,
                        ComplaintDate = c.ComplaintDate,
                        AssignedToId = c.AssignedToId,
                        AsignToName = c.AssignedTo != null ? $"{c.AssignedTo.FirstName} {c.AssignedTo.LastName}" : "",
                        ComplaintTypeId = c.ComplaintTypeId,
                        ComplaintTypeName = c.ComplaintType != null ? $"{c.ComplaintType.Name} " : " ",
                    })
                    .ToListAsync();
                return risk;
            }
            catch (Exception ex)
            {
                throw new DataException("Error while getting Complaint", ex);
            }
        }
    }
}
