﻿using Microsoft.EntityFrameworkCore;
using QualityManagement.Common.GenericRepository;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Resources;
using QualityManagement.Domain;
using System.Linq;
using System.Threading.Tasks;

namespace QualityManagement.Repository;
public class CourseRepository(
    IPropertyMappingService _propertyMappingService,
    IUnitOfWork<QMSDbContext> uow) : GenericRepository<Course, QMSDbContext>(uow),
          ICourseRepository
{
    public async Task<CourseList> GetCourses(CourseResource courseResource)
    {
        var collectionBeforePaging = All;
        collectionBeforePaging =
           collectionBeforePaging.ApplySort(courseResource.OrderBy,
           _propertyMappingService.GetPropertyMapping<CourseDto, Course>());

        if (courseResource.CourseStatus.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
                .Where(c => c.CourseStatus == courseResource.CourseStatus.Value);
        }
        if (!string.IsNullOrWhiteSpace(courseResource.Title))
        {
            collectionBeforePaging = collectionBeforePaging
                .Where(c =>
               EF.Functions.Like(c.Title, $"%{courseResource.Title}"));
        }
        if (!string.IsNullOrWhiteSpace(courseResource.Description))
        {
            collectionBeforePaging = collectionBeforePaging
                .Where(c =>
               EF.Functions.Like(c.Description, $"%{courseResource.Description}"));
        }

        var courses = new CourseList();

        return await courses.Create(collectionBeforePaging,
            courseResource.Skip,
            courseResource.PageSize);
    }
}
