﻿using System.Linq;
using System.Threading.Tasks;
using QualityManagement.Common.GenericRepository;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Data.Resources;
using QualityManagement.Domain;

namespace QualityManagement.Repository;

public class NonConformanceRepository(
    IUnitOfWork<QMSDbContext> uow,
     IPropertyMappingService _propertyMappingService) : GenericRepository<Data.Entities.NonConformance, QMSDbContext>(uow), INonConformanceRepository
{
    public async Task<NonConformanceList> GetNonConformances(NonConformanceResource nonConformanceResource)
    {

        var collectionBeforePaging = AllIncluding(c => c.Department, c => c.ReportedBy);

        collectionBeforePaging = collectionBeforePaging.ApplySort(nonConformanceResource.OrderBy,
            _propertyMappingService.GetPropertyMapping<NonConformanceDto, NonConformance>());

        if (!string.IsNullOrWhiteSpace(nonConformanceResource.NCNumber))
        {
            collectionBeforePaging = collectionBeforePaging
            .Where(c => c.NCNumber.Contains(nonConformanceResource.NCNumber));
        }
        if (nonConformanceResource.ReportedById.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
          .Where(c => c.ReportedById == nonConformanceResource.ReportedById);
        }
        if (nonConformanceResource.AuditId.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
          .Where(c => c.AuditId == nonConformanceResource.AuditId);
        }
        if (nonConformanceResource.DepartmentId.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
          .Where(c => c.DepartmentId == nonConformanceResource.DepartmentId);
        }
        if (nonConformanceResource.Status.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
                .Where(c => c.Status == nonConformanceResource.Status);
        }
        if (nonConformanceResource.Severity.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
                .Where(c => c.Severity == nonConformanceResource.Severity);
        }

        var nonConformanceList = new NonConformanceList();
        return await nonConformanceList.Create(
            collectionBeforePaging,
            nonConformanceResource.Skip,
            nonConformanceResource.PageSize);
    }
}
