﻿using Microsoft.EntityFrameworkCore;
using QualityManagement.Common.GenericRepository;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Data.Resources;
using QualityManagement.Domain;
using System.Linq;
using System.Threading.Tasks;

namespace QualityManagement.Repository;
public class UserOpenaiMsgRepository(
    IPropertyMappingService _propertyMappingService,
    IUnitOfWork<QMSDbContext> uow) : GenericRepository<UserOpenaiMsg, QMSDbContext>(uow),
          IUserOpenaiMsgRepository
{

    public async Task<UserOpenaiMsgList> GetUserOpenaiMsgAsync(UserOpenaiMsgResource userOpenaiMsgResource)
    {
        var collectionBeforePaging = All;
        collectionBeforePaging =
           collectionBeforePaging.ApplySort(userOpenaiMsgResource.OrderBy,
           _propertyMappingService.GetPropertyMapping<UserOpenaiMsgDto, UserOpenaiMsg>());

        if (!string.IsNullOrWhiteSpace(userOpenaiMsgResource.Title))
        {
            collectionBeforePaging = collectionBeforePaging
                .Where(c => EF.Functions.Like(c.Title, $"%{userOpenaiMsgResource.Title.Trim()}%"));
        }
        if (!string.IsNullOrWhiteSpace(userOpenaiMsgResource.PromptInput))
        {
            collectionBeforePaging = collectionBeforePaging
                .Where(c => EF.Functions.Like(c.PromptInput, $"%{userOpenaiMsgResource.PromptInput.Trim()}%"));
        }


        var userOpenaiMsgList = new UserOpenaiMsgList();
        return await userOpenaiMsgList.Create(
            collectionBeforePaging,
            userOpenaiMsgResource.Skip,
            userOpenaiMsgResource.PageSize
            );
    }
}