﻿using System;
using System.Collections.Generic;
using System.Linq;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Dto.RiskManagement;
using QualityManagement.Data.Entities;

namespace QualityManagement.Repository;

public class PropertyMappingService : IPropertyMappingService
{
    private readonly Dictionary<string, PropertyMappingValue> _documentPropertyMapping =
       new Dictionary<string, PropertyMappingValue>(StringComparer.OrdinalIgnoreCase)
       {
           { "Id", new PropertyMappingValue(new List<string>() { "Id" } ) },
           { "DocumentNumber", new PropertyMappingValue(new List<string>() { "DocumentNumber" } )},
           { "Name", new PropertyMappingValue(new List<string>() { "Name" } )},
           { "Description", new PropertyMappingValue(new List<string>() { "Description" } )},
           { "CreatedBy", new PropertyMappingValue(new List<string>() { "User.FirstName" } )},
           { "CreatedDate", new PropertyMappingValue(new List<string>() { "CreatedDate" } )},
           { "CategoryName", new PropertyMappingValue(new List<string>() { "Category.Name" } )},
           { "DocumentStatus", new PropertyMappingValue(new List<string>() { "DocumentStatus.Name" } )},
           { "Client", new PropertyMappingValue(new List<string>() { "Client.CompanyName" } )},
           { "StorageType", new PropertyMappingValue(new List<string>() { "StorageType" } )},
           { "SignDate", new PropertyMappingValue(new List<string>() { "SignDate" } )},
           { "ExpiredDate", new PropertyMappingValue(new List<string>() { "ExpiredDate" } )},
           { "ArchiveName", new PropertyMappingValue(new List<string>() { "ArchiveBy.FirstName" } )}
       };

    private readonly Dictionary<string, PropertyMappingValue> _documentAuditTrailPropertyMapping =
      new Dictionary<string, PropertyMappingValue>(StringComparer.OrdinalIgnoreCase)
      {
           { "Id", new PropertyMappingValue(new List<string>() { "Id" } ) },
                          { "Name", new PropertyMappingValue(new List<string>() { "Document.Name" } )},
           { "DocumentName", new PropertyMappingValue(new List<string>() { "Document.Name" } )},
           { "DocumentNumber", new PropertyMappingValue(new List<string>() { "Document.DocumentNumber" } )},
           { "DocumentId", new PropertyMappingValue(new List<string>() { "DocumentId" } )},
           { "CategoryName", new PropertyMappingValue(new List<string>() { "Document.Category.Name" } )},
           { "CreatedBy", new PropertyMappingValue(new List<string>() { "CreatedByUser.FirstName" } )},
           { "CreatedDate", new PropertyMappingValue(new List<string>() { "CreatedDate" } )},
           { "OperationName", new PropertyMappingValue(new List<string>() { "OperationName" } )},
           { "PermissionUser", new PropertyMappingValue(new List<string>() { "AssignToUser.FirstName" } )},
           { "PermissionRole", new PropertyMappingValue(new List<string>() { "AssignToRole.Name" } )}
      };

    private readonly Dictionary<string, PropertyMappingValue> _notificationPropertyMapping =
        new Dictionary<string, PropertyMappingValue>(StringComparer.OrdinalIgnoreCase)
        {
            { "Id", new PropertyMappingValue(new List<string>() { "Id" } ) },
            { "UserId", new PropertyMappingValue(new List<string>() { "UserId" } ) },
            { "Message", new PropertyMappingValue(new List<string>() { "Message" } ) },
            { "DocumentId", new PropertyMappingValue(new List<string>() { "DocumentId" } ) },
            { "DocumentName", new PropertyMappingValue(new List<string>() { "Document.Name" } )},
            { "CreatedDate", new PropertyMappingValue(new List<string>() { "CreatedDate" } )},
            { "IsRead", new PropertyMappingValue(new List<string>() { "IsRead" } )}
        };

    private readonly Dictionary<string, PropertyMappingValue> _loginAuditMapping =
        new Dictionary<string, PropertyMappingValue>(StringComparer.OrdinalIgnoreCase)
        {
            { "Id", new PropertyMappingValue(new List<string>() { "Id" } ) },
            { "UserName", new PropertyMappingValue(new List<string>() { "UserName" } )},
            { "LoginTime", new PropertyMappingValue(new List<string>() { "LoginTime" } )},
            { "RemoteIP", new PropertyMappingValue(new List<string>() { "RemoteIP" } )},
            { "Status", new PropertyMappingValue(new List<string>() { "Status" } )},
            { "Provider", new PropertyMappingValue(new List<string>() { "Provider" } )}
        };

    private readonly Dictionary<string, PropertyMappingValue> _reminderMapping =
        new Dictionary<string, PropertyMappingValue>(StringComparer.OrdinalIgnoreCase)
        {
            { "Id", new PropertyMappingValue(new List<string>() { "Id" } ) },
            { "Subject", new PropertyMappingValue(new List<string>() { "Subject" } )},
            { "Message", new PropertyMappingValue(new List<string>() { "Message" } )},
            { "Frequency", new PropertyMappingValue(new List<string>() { "Frequency" } )},
            { "DocumentName", new PropertyMappingValue(new List<string>() { "Document.Name" } )},
            { "DocumentNumber", new PropertyMappingValue(new List<string>() { "Document.DocumentNumber" } )},
            { "StartDate", new PropertyMappingValue(new List<string>() { "StartDate" },true )},
            { "EndDate", new PropertyMappingValue(new List<string>() { "EndDate" },true )},
            { "CreatedDate", new PropertyMappingValue(new List<string>() { "CreatedDate" } )},
            { "IsRepeated", new PropertyMappingValue(new List<string>() { "IsRepeated" } )},
            { "IsEmailNotification", new PropertyMappingValue(new List<string>() { "IsEmailNotification" } )},
            { "IsActive", new PropertyMappingValue(new List<string>() { "IsActive" } )}
        };

    private readonly Dictionary<string, PropertyMappingValue> _reminderSchedulerMapping =
       new Dictionary<string, PropertyMappingValue>(StringComparer.OrdinalIgnoreCase)
       {
            { "Id", new PropertyMappingValue(new List<string>() { "Id" } ) },
            { "Subject", new PropertyMappingValue(new List<string>() { "Subject" } )},
            { "Message", new PropertyMappingValue(new List<string>() { "Message" } )},
            { "IsRead", new PropertyMappingValue(new List<string>() { "IsRead" } )},
            { "CreatedDate", new PropertyMappingValue(new List<string>() { "CreatedDate" }, true )}
       };

    private readonly Dictionary<string, PropertyMappingValue> _nLogMapping =
        new Dictionary<string, PropertyMappingValue>(StringComparer.OrdinalIgnoreCase)
        {
            { "Id", new PropertyMappingValue(new List<string>() { "Id" } ) },
            { "MachineName", new PropertyMappingValue(new List<string>() { "MachineName" } )},
            { "Logged", new PropertyMappingValue(new List<string>() { "Logged" } )},
            { "Level", new PropertyMappingValue(new List<string>() { "Level" } )},
            { "Message", new PropertyMappingValue(new List<string>() { "Message" } )},
            { "Logger", new PropertyMappingValue(new List<string>() { "Logger" } )},
            { "Properties", new PropertyMappingValue(new List<string>() { "Properties" } )},
            { "Callsite", new PropertyMappingValue(new List<string>() { "Callsite" } )},
            { "Exception", new PropertyMappingValue(new List<string>() { "Exception" } )}
        };

    private readonly Dictionary<string, PropertyMappingValue> _userMapping =
        new Dictionary<string, PropertyMappingValue>(StringComparer.OrdinalIgnoreCase)
        {
            { "Id", new PropertyMappingValue(new List<string>() { "Id" } ) },
            { "Email", new PropertyMappingValue(new List<string>() { "Email" } )},
            { "FirstName", new PropertyMappingValue(new List<string>() { "FirstName" } )},
            { "LastName", new PropertyMappingValue(new List<string>() { "LastName" } )},
            { "PhoneNumber", new PropertyMappingValue(new List<string>() { "PhoneNumber" })},
            { "IsDeleted", new PropertyMappingValue(new List<string>() { "IsDeleted" })}
        };


    private readonly Dictionary<string, PropertyMappingValue> _courseMapping =
        new Dictionary<string, PropertyMappingValue>(StringComparer.OrdinalIgnoreCase)
        {
            { "Id", new PropertyMappingValue(new List<string>() { "Id" } ) },
            { "Title", new PropertyMappingValue(new List<string>() { "Title" } )},
            { "Description", new PropertyMappingValue(new List<string>() { "Description" } )},
            { "CourseType", new PropertyMappingValue(new List<string>() { "CourseType" } )},
            { "StartDate", new PropertyMappingValue(new List<string>() { "StartDate" } )},
            { "EndDate", new PropertyMappingValue(new List<string>() { "EndDate" } )},
            { "CourseStatus", new PropertyMappingValue(new List<string>() { "CourseStatus" } )}
        };

    private readonly Dictionary<string, PropertyMappingValue> _employeeCourseSessionMapping =
    new Dictionary<string, PropertyMappingValue>(StringComparer.OrdinalIgnoreCase)
    {
        { "Id", new PropertyMappingValue(new List<string>() { "Id" } ) },
        { "EmployeeId", new PropertyMappingValue(new List<string>() { "EmployeeId" } ) },
        { "AssignedDate", new PropertyMappingValue(new List<string>() { "AssignedDate" } ) },
        { "CompletedDate", new PropertyMappingValue(new List<string>() { "CompletedDate" } ) },
        { "EmployeeName", new PropertyMappingValue(new List<string>() { "Employee.FirstName" }) },
        { "IsCompleted", new PropertyMappingValue(new List<string>() {"IsCompleted"}) }
    };

    private readonly Dictionary<string, PropertyMappingValue> _employeeCourseSessionDtoMapping =
        new Dictionary<string, PropertyMappingValue>(StringComparer.OrdinalIgnoreCase)
        {
            { "Id", new PropertyMappingValue(new List<string>() { "Id" } ) },
            { "EmployeeId", new PropertyMappingValue(new List<string>() { "EmployeeId" } ) },
            { "AssignedDate", new PropertyMappingValue(new List<string>() { "AssignedDate" } ) },
            { "CompletedDate", new PropertyMappingValue(new List<string>() { "CompletedDate" } ) },
            {"EmployeeName",new PropertyMappingValue(new List<string>() {"Employee.FirstName"}) },
            { "CourseName", new PropertyMappingValue(new List<string>() { "CourseSession.Course.Title" }) },
            { "SessionName", new PropertyMappingValue(new List<string>() {"CourseSession.Title"}) }
        };

    private readonly Dictionary<string, PropertyMappingValue> _employeeCourseMapping =
        new Dictionary<string, PropertyMappingValue>(StringComparer.OrdinalIgnoreCase)
        {
            { "Id", new PropertyMappingValue(new List<string>() { "Id" } ) },
            { "EmployeeId", new PropertyMappingValue(new List<string>() { "EmployeeId" } ) },
            { "CompletedDate", new PropertyMappingValue(new List<string>() { "CompletedDate" } ) },
            { "CourseName", new PropertyMappingValue(new List<string>() { "Course.Title" }) },
            { "EmployeeName", new PropertyMappingValue(new List<string>() { "Employee.FirstName" }) },
            { "Status", new PropertyMappingValue(new List<string>() { "Status" }) },
            { "CreatedDate", new PropertyMappingValue(new List<string>() { "CreatedDate" }, true ) },
            { "AssignedDate", new PropertyMappingValue(new List<string>() { "CreatedDate" }, true ) },
            { "DueDate", new PropertyMappingValue(new List<string>() { "DueDate" }) }
        };

    private readonly Dictionary<string, PropertyMappingValue> _workflowInstanceMapping =
       new Dictionary<string, PropertyMappingValue>(StringComparer.OrdinalIgnoreCase)
       {
            { "WorkflowId", new PropertyMappingValue(new[] { "Workflow.Id" }) },
            { "WorkflowName", new PropertyMappingValue(new[] { "Workflow.Name" }) },
            { "WorkflowInstanceId", new PropertyMappingValue(new[] { "Id" }) },
            { "WorkflowStepInstanceId", new PropertyMappingValue(new[] { "WorkflowStepInstances.Id" }) },
            { "WorkflowInstanceStatus", new PropertyMappingValue(new[] { "Status" }) },
            { "WorkflowStepId", new PropertyMappingValue(new[] { "WorkflowStepInstances.StepId" }) },
            { "WorkflowStepName", new PropertyMappingValue(new[] { "WorkflowStepInstances.WorkflowStep.StepName" }) },
            { "WorkflowStepInstanceStatus", new PropertyMappingValue(new[] { "WorkflowStepInstances.Status" }) },
            { "DocumentId", new PropertyMappingValue(new[] { "DocumentId" }) },
            { "DocumentName", new PropertyMappingValue(new[] { "Document.Name" }) },
            { "DocumentNumber", new PropertyMappingValue(new[] { "Document.DocumentNumber" }) },
            { "UpdatedAt", new PropertyMappingValue(new[] { "UpdatedAt" }, true ) },
       };

    private readonly Dictionary<string, PropertyMappingValue> _workflowTransitionLogMapping =
       new Dictionary<string, PropertyMappingValue>(StringComparer.OrdinalIgnoreCase)
       {
            { "WorkflowInstanceId", new PropertyMappingValue(new[] { "Id" }) },
            { "WorkflowId", new PropertyMappingValue(new[] { "WorkflowInstance.Workflow.Id" }) },
            { "WorkflowName", new PropertyMappingValue(new[] { "WorkflowInstance.Workflow.Name" }) },
            { "DocumentId", new PropertyMappingValue(new[] { "WorkflowInstance.Document.Id" }) },
            { "DocumentNumber", new PropertyMappingValue(new[] { "WorkflowInstance.Document.DocumentNumber" }) },
            { "DocumentName", new PropertyMappingValue(new[] { "WorkflowInstance.Document.Name" }) },
            { "WorkflowInstanceStatus", new PropertyMappingValue(new[] { "WorkflowInstance.Status" }) },
            { "TransitionName", new PropertyMappingValue(new[] { "WorkflowTransition.Name" }) },
            { "InitiatedBy", new PropertyMappingValue(new[] { "WorkflowInstance.InitiatedBy" }) },
            { "Steps", new PropertyMappingValue(new[] { "WorkflowTransition.FromWorkflowStep" }) },
            { "WorkflowTransitionInstanceStatus", new PropertyMappingValue(new[] { "Status" }) },
            { "InititatedAt", new PropertyMappingValue(new[] { "WorkflowInstance.CreatedAt" }) },
            { "TransitionDate", new PropertyMappingValue(new[] { "UpdatedAt" }, true ) },
            { "PerformBy", new PropertyMappingValue(new[] { "PerformBy" }) },
            { "Comment", new PropertyMappingValue(new[] { "Comment" }) },

       };

    private readonly Dictionary<string, PropertyMappingValue> _userOpenaiMsgMapping =
       new Dictionary<string, PropertyMappingValue>(StringComparer.OrdinalIgnoreCase)
       {
            { "Id", new PropertyMappingValue(new[] { "Id" }) },
            { "Title", new PropertyMappingValue(new List<string>() { "Title" } )},
            { "PromptInput", new PropertyMappingValue(new List<string>() { "PromptInput" } )},
            { "Language", new PropertyMappingValue(new List<string>() { "Language" } )},
            { "MaximumLength", new PropertyMappingValue(new List<string>() { "MaximumLength" } )},
            { "Creativity", new PropertyMappingValue(new List<string>() { "Creativity" } )},
            { "ToneOfVoice", new PropertyMappingValue(new List<string>() { "ToneOfVoice" } )},
            { "SelectedModel", new PropertyMappingValue(new List<string>() { "SelectedModel" } )},
            { "CreatedDate", new PropertyMappingValue(new List<string>() { "CreatedDate" } )},
       };

    //
    private readonly Dictionary<string, PropertyMappingValue> _auditTemplateMapping =
       new Dictionary<string, PropertyMappingValue>(StringComparer.OrdinalIgnoreCase)
       {
            { "Name", new PropertyMappingValue(new List<string>() { "Name" } )},
            { "AuditType", new PropertyMappingValue(new List<string>() { "AuditType" } )},
            { "DepartmentId", new PropertyMappingValue(new List<string>() { "DepartmentId" } )}
       };

    private readonly Dictionary<string, PropertyMappingValue> _auditMapping =
       new Dictionary<string, PropertyMappingValue>(StringComparer.OrdinalIgnoreCase)
       {
            { "AuditTemplateName", new PropertyMappingValue(new List<string>() { "AuditTemplate.Name" } )},
            { "AuditStatus", new PropertyMappingValue(new List<string>() { "Status" } )},
            { "score", new PropertyMappingValue(new List<string>() { "TotalScore" } )},
            { "AuditType", new PropertyMappingValue(new List<string>() { "AuditTemplate.AuditType" } )},
            { "AuditReviewComments", new PropertyMappingValue(new List<string>() {"AuditReviewComments.Count"}) },
            { "AuditReviewersComment", new PropertyMappingValue(new List<string>() {"AuditReviewers.Count"}) },
            { "DepartmentId", new PropertyMappingValue(new List<string>() { "DepartmentId" } )},
            { "AuditorId", new PropertyMappingValue(new List<string>() { "AuditorId" } )},
            { "AuditorName", new PropertyMappingValue(new List<string>() { "Auditor.FirstName" }) },
            { "Description", new PropertyMappingValue(new List<string>() { "AuditTemplate.Description" } )},
            { "Title", new PropertyMappingValue(new List<string>() { "Title" } )},
            { "NonConformance", new PropertyMappingValue(new List<string>() { "NonConformances.Count" } )},
            { "CapaRequest", new PropertyMappingValue(new List<string>() { "CapaRequests.Count" } )},
            { "Department", new PropertyMappingValue(new List<string>() { "AuditTemplate.Department.Name" }) },
            { "AuditNumber", new PropertyMappingValue(new List<string>() { "AuditNumber" }) },
            { "ModifiedDate", new PropertyMappingValue(new List<string>() { "ModifiedDate" },true) },
       };

    private readonly Dictionary<string, PropertyMappingValue> _nonConformanceMapping =
    new Dictionary<string, PropertyMappingValue>(StringComparer.OrdinalIgnoreCase)
    {
            { "NCNumber", new PropertyMappingValue(new List<string>() { "NCNumber" } )},
            { "Title", new PropertyMappingValue(new List<string>() { "Title" } )},
            { "ReportedBy", new PropertyMappingValue(new List<string>() { "ReportedBy.FirstName" } )},
            { "Severity", new PropertyMappingValue(new List<string>() { "Severity" } )},
            { "Status", new PropertyMappingValue(new List<string>() { "Status" } )},
            { "department", new PropertyMappingValue(new List<string>() { "Department.Name" } )},
             { "Description", new PropertyMappingValue(new List<string>() { "Description" } )},
             { "audit", new PropertyMappingValue(new List<string>() { "Audit.AuditNumber" } )}
    };

    private readonly Dictionary<string, PropertyMappingValue> _capaRequestMapping =
    new Dictionary<string, PropertyMappingValue>(StringComparer.OrdinalIgnoreCase)
    {
            { "ReferenceNo", new PropertyMappingValue(new List<string>() { "ReferenceNo" } )},
            { "Title", new PropertyMappingValue(new List<string>() { "Title" } )},
            { "Description", new PropertyMappingValue(new List<string>() { "Description" } )},
            { "raiseById", new PropertyMappingValue(new List<string>() { "RaisedBY.FirstName" } )},
            { "ncNumber", new PropertyMappingValue(new List<string>() { "NonConformance.NCNumber" } )},
            { "AuditId", new PropertyMappingValue(new List<string>() { "AuditId" } )},
            { "status", new PropertyMappingValue(new List<string>() { "CapaRequestStatus" } )},
            { "Audit", new PropertyMappingValue(new List<string>() { "Audit.Title" } )},
            { "Priority", new PropertyMappingValue(new List<string>() { "Priority" } )},
            { "DueDate", new PropertyMappingValue(new List<string>() { "DueDate" } )}
    };

    private readonly Dictionary<string, PropertyMappingValue> _riskMapping =
   new Dictionary<string, PropertyMappingValue>(StringComparer.OrdinalIgnoreCase)
   {
            { "Title", new PropertyMappingValue(new List<string>() { "Title" } )},
            { "Description", new PropertyMappingValue(new List<string>() { "Description" } )},
            { "RiskCategoryId", new PropertyMappingValue(new List<string>() { "RiskCategory.Name" } )},
            { "RiskScore", new PropertyMappingValue(new List<string>() { "RiskScore" } )},
            { "CreatedBy", new PropertyMappingValue(new List<string>() { "CreatedUser.FirstName" } )},
            { "assignToId", new PropertyMappingValue(new List<string>() { "AssignedTo.FirstName" } )},
            { "CreatedDate", new PropertyMappingValue(new List<string>() { "CreatedDate" } )},
            { "riskLavel", new PropertyMappingValue(new List<string>() { "RiskLevel" } )},
            { "Status", new PropertyMappingValue(new List<string>() { "Status" } )}
   };

    private readonly Dictionary<string, PropertyMappingValue> _complaintMapping =
new Dictionary<string, PropertyMappingValue>(StringComparer.OrdinalIgnoreCase)
{
            { "Title", new PropertyMappingValue(new List<string>() { "Title" } )},
            { "Description", new PropertyMappingValue(new List<string>() { "Description" } )},
            { "ComplaintNo", new PropertyMappingValue(new List<string>() { "ComplaintNo" } )},
            { "ComplaintDate", new PropertyMappingValue(new List<string>() { "ComplaintDate" } )},
            { "reportedBy", new PropertyMappingValue(new List<string>() { "ReportedBy" } )},
            { "AssignedToId", new PropertyMappingValue(new List<string>() { "AssignedTo.FirstName" } )},
            { "complaintType", new PropertyMappingValue(new List<string>() { "ComplaintType.Name" } )},
            { "Priority", new PropertyMappingValue(new List<string>() { "Priority" } )},
            { "Status", new PropertyMappingValue(new List<string>() { "Status" } )},
            { "ResolutionSummary", new PropertyMappingValue(new List<string>() { "ResolutionSummary" } )}
};


    private readonly Dictionary<string, PropertyMappingValue> _supplierMapping =
    new Dictionary<string, PropertyMappingValue>(StringComparer.OrdinalIgnoreCase)
    {
            { "SupplierCode", new PropertyMappingValue(new List<string>() { "SupplierCode" } )},
            { "Name", new PropertyMappingValue(new List<string>() { "Name" } )},
            { "ContactPerson", new PropertyMappingValue(new List<string>() { "ContactPerson" } )},
            { "Email", new PropertyMappingValue(new List<string>() { "Email" } )},
            { "Phone", new PropertyMappingValue(new List<string>() { "Phone" } )},
            { "Country", new PropertyMappingValue(new List<string>() { "Country" } )},
            { "Status", new PropertyMappingValue(new List<string>() { "Status" } )},
            { "Address", new PropertyMappingValue(new List<string>() { "Address" } )}
    };


    private readonly Dictionary<string, PropertyMappingValue> _capaRequestLogMapping =
  new Dictionary<string, PropertyMappingValue>(StringComparer.OrdinalIgnoreCase)
  {
            { "ReferenceNo", new PropertyMappingValue(new List<string>() { "ReferenceNo" } )},
            { "Title", new PropertyMappingValue(new List<string>() { "Title" } )},
            { "Description", new PropertyMappingValue(new List<string>() { "Description" } )},
            { "raiseById", new PropertyMappingValue(new List<string>() { "RaisedBY.FirstName" } )},
            { "ncNumber", new PropertyMappingValue(new List<string>() { "NonConformance.NCNumber" } )},
            { "AuditId", new PropertyMappingValue(new List<string>() { "AuditId" } )},
            { "status", new PropertyMappingValue(new List<string>() { "CapaRequestStatus" } )},
            { "LogStatus", new PropertyMappingValue(new List<string>() { "LogStatus" } )},
            { "Audit", new PropertyMappingValue(new List<string>() { "Audit.Title" } )},
            { "Priority", new PropertyMappingValue(new List<string>() { "Priority" } )},
            { "DueDate", new PropertyMappingValue(new List<string>() { "DueDate" } )}
  };

    private readonly Dictionary<string, PropertyMappingValue> _complaintLogMapping =
new Dictionary<string, PropertyMappingValue>(StringComparer.OrdinalIgnoreCase)
{
            { "Title", new PropertyMappingValue(new List<string>() { "Title" } )},
            { "Description", new PropertyMappingValue(new List<string>() { "Description" } )},
            { "ComplaintNo", new PropertyMappingValue(new List<string>() { "ComplaintNo" } )},
            { "ComplaintDate", new PropertyMappingValue(new List<string>() { "ComplaintDate" } )},
            { "reportedBy", new PropertyMappingValue(new List<string>() { "ReportedBy" } )},
            { "AssignedToId", new PropertyMappingValue(new List<string>() { "AssignedTo.FirstName" } )},
            { "complaintType", new PropertyMappingValue(new List<string>() { "ComplaintType.Name" } )},
            { "Priority", new PropertyMappingValue(new List<string>() { "Priority" } )},
            { "Status", new PropertyMappingValue(new List<string>() { "Status" } )},
            { "LogStatus", new PropertyMappingValue(new List<string>() { "LogStatus" } )},
            { "ResolutionSummary", new PropertyMappingValue(new List<string>() { "ResolutionSummary" } )}
};


    private readonly Dictionary<string, PropertyMappingValue> _nonConformanceLogMapping =
    new Dictionary<string, PropertyMappingValue>(StringComparer.OrdinalIgnoreCase)
    {
            { "NCNumber", new PropertyMappingValue(new List<string>() { "NCNumber" } )},
            { "Title", new PropertyMappingValue(new List<string>() { "Title" } )},
            { "ReportedBy", new PropertyMappingValue(new List<string>() { "ReportedBy.FirstName" } )},
            { "Severity", new PropertyMappingValue(new List<string>() { "Severity" } )},
            { "Status", new PropertyMappingValue(new List<string>() { "Status" } )},
            { "LogStatus", new PropertyMappingValue(new List<string>() { "LogStatus" } )},
            { "department", new PropertyMappingValue(new List<string>() { "Department.Name" } )},
             { "Description", new PropertyMappingValue(new List<string>() { "Description" } )},
             { "audit", new PropertyMappingValue(new List<string>() { "Audit.AuditNumber" } )}
    };

    private readonly Dictionary<string, PropertyMappingValue> _riskLogMapping =
    new Dictionary<string, PropertyMappingValue>(StringComparer.OrdinalIgnoreCase)
 {
            { "Title", new PropertyMappingValue(new List<string>() { "Title" } )},
            { "Description", new PropertyMappingValue(new List<string>() { "Description" } )},
            { "RiskCategoryId", new PropertyMappingValue(new List<string>() { "RiskCategory.Name" } )},
            { "RiskScore", new PropertyMappingValue(new List<string>() { "RiskScore" } )},
            { "CreatedBy", new PropertyMappingValue(new List<string>() { "CreatedByUser.FirstName" } )},
            { "assignToId", new PropertyMappingValue(new List<string>() { "AssignedTo.FirstName" } )},
            { "CreatedDate", new PropertyMappingValue(new List<string>() { "CreatedDate" } )},
            { "riskLavel", new PropertyMappingValue(new List<string>() { "RiskLevel" } )},
            { "Status", new PropertyMappingValue(new List<string>() { "Status" } )},
            { "LogStatus", new PropertyMappingValue(new List<string>() { "LogStatus" } )}
 };

    private readonly Dictionary<string, PropertyMappingValue> _auditResponseLogMapping =
       new Dictionary<string, PropertyMappingValue>(StringComparer.OrdinalIgnoreCase)
       {
            { "AuditTemplateName", new PropertyMappingValue(new List<string>() { "Audit.AuditTemplate.Name" } )},
            { "AuditStatus", new PropertyMappingValue(new List<string>() { "Status" } )},
            { "score", new PropertyMappingValue(new List<string>() { "Audit.TotalScore" } )},
            { "AuditType", new PropertyMappingValue(new List<string>() { "Audit.AuditTemplate.AuditType" } )},
            { "DepartmentId", new PropertyMappingValue(new List<string>() { "Audit.DepartmentId" } )},
            { "AuditorId", new PropertyMappingValue(new List<string>() { "Audit.AuditorId" } )},
            { "AuditorName", new PropertyMappingValue(new List<string>() { "Audit.Auditor.FirstName" }) },
            { "Description", new PropertyMappingValue(new List<string>() { "Audit.AuditTemplate.Description" } )},
            { "Title", new PropertyMappingValue(new List<string>() { "Audit.Title" } )},
            { "NonConformance", new PropertyMappingValue(new List<string>() { "NonConformance" } )},
            { "CapaRequest", new PropertyMappingValue(new List<string>() { "CapaRequest" } )},
            { "Department", new PropertyMappingValue(new List<string>() { "Audit.AuditTemplate.Department.Name" }) },
            { "Question", new PropertyMappingValue(new List<string>() { "Question.Question" }) },
            { "Response", new PropertyMappingValue(new List<string>() { "Response" }) },
            { "LogStatus", new PropertyMappingValue(new List<string>() { "LogStatus" } )},
            { "AuditDate", new PropertyMappingValue(new List<string>() { "CreatedDate" } )},
       };
    private readonly IList<IPropertyMapping> propertyMappings = new List<IPropertyMapping>();
    public PropertyMappingService()
    {
        propertyMappings.Add(new PropertyMapping<LoginAuditDto, LoginAudit>(_loginAuditMapping));
        propertyMappings.Add(new PropertyMapping<DocumentDto, Document>(_documentPropertyMapping));
        propertyMappings.Add(new PropertyMapping<DocumentAuditTrailDto, DocumentAuditTrail>(_documentAuditTrailPropertyMapping));
        propertyMappings.Add(new PropertyMapping<UserNotificationDto, UserNotification>(_notificationPropertyMapping));
        propertyMappings.Add(new PropertyMapping<ReminderDto, Reminder>(_reminderMapping));
        propertyMappings.Add(new PropertyMapping<ReminderSchedulerDto, ReminderScheduler>(_reminderSchedulerMapping));
        propertyMappings.Add(new PropertyMapping<NLogDto, NLog>(_nLogMapping));
        propertyMappings.Add(new PropertyMapping<UserDto, User>(_userMapping));
        propertyMappings.Add(new PropertyMapping<CurrentWorkflowDataDto, WorkflowInstance>(_workflowInstanceMapping));
        propertyMappings.Add(new PropertyMapping<WorkflowTransitionLogDto, WorkflowTransitionInstance>(_workflowTransitionLogMapping));
        propertyMappings.Add(new PropertyMapping<UserOpenaiMsgDto, UserOpenaiMsg>(_userOpenaiMsgMapping));
        propertyMappings.Add(new PropertyMapping<CourseDto, Course>(_courseMapping));
        propertyMappings.Add(new PropertyMapping<EmployeeCourseSessionListDetailDto, EmployeeCourseSession>(_employeeCourseSessionMapping));
        propertyMappings.Add(new PropertyMapping<EmployeeCourseSessionDto, EmployeeCourseSession>(_employeeCourseSessionDtoMapping));
        propertyMappings.Add(new PropertyMapping<EmployeeCourseDto, EmployeeCourse>(_employeeCourseMapping));
        propertyMappings.Add(new PropertyMapping<AuditTemplateDto, AuditTemplate>(_auditTemplateMapping));
        propertyMappings.Add(new PropertyMapping<NonConformanceDto, NonConformance>(_nonConformanceMapping));
        propertyMappings.Add(new PropertyMapping<CapaRequestDto, CapaRequest>(_capaRequestMapping));
        propertyMappings.Add(new PropertyMapping<AuditDto, Audit>(_auditMapping));
        propertyMappings.Add(new PropertyMapping<RiskDto, Risk>(_riskMapping));
        propertyMappings.Add(new PropertyMapping<SupplierDto, Supplier>(_supplierMapping));
        propertyMappings.Add(new PropertyMapping<ComplaintDto, Complaint>(_complaintMapping));
        propertyMappings.Add(new PropertyMapping<CapaRequestLogDto, CapaRequestLog>(_capaRequestLogMapping));
        propertyMappings.Add(new PropertyMapping<ComplaintLogDto, ComplaintLog>(_complaintLogMapping));
        propertyMappings.Add(new PropertyMapping<NonConformanceLogDto, NonConformanceLog>(_nonConformanceLogMapping));
        propertyMappings.Add(new PropertyMapping<RiskLogDto, RiskLog>(_riskLogMapping));
        propertyMappings.Add(new PropertyMapping<AuditResponseLogDto, AuditResponseLog>(_auditResponseLogMapping));
    }
    public Dictionary<string, PropertyMappingValue> GetPropertyMapping
        <TSource, TDestination>()
    {
        // get matching mapping
        var matchingMapping = propertyMappings.OfType<PropertyMapping<TSource, TDestination>>();

        if (matchingMapping.Count() == 1)
        {
            return matchingMapping.First()._mappingDictionary;
        }

        throw new Exception($"Cannot find exact property mapping instance for <{typeof(TSource)},{typeof(TDestination)}");
    }

    public bool ValidMappingExistsFor<TSource, TDestination>(string fields)
    {
        var propertyMapping = GetPropertyMapping<TSource, TDestination>();

        if (string.IsNullOrWhiteSpace(fields))
        {
            return true;
        }

        // the string is separated by ",", so we split it.
        var fieldsAfterSplit = fields.Split(',');

        // run through the fields clauses
        foreach (var field in fieldsAfterSplit)
        {
            // trim
            var trimmedField = field.Trim();

            // remove everything after the first " " - if the fields 
            // are coming from an orderBy string, this part must be 
            // ignored
            var indexOfFirstSpace = trimmedField.IndexOf(" ");
            var propertyName = indexOfFirstSpace == -1 ?
                trimmedField : trimmedField.Remove(indexOfFirstSpace);

            // find the matching property
            if (!propertyMapping.ContainsKey(propertyName))
            {
                return false;
            }
        }
        return true;

    }

}
