﻿using QualityManagement.Common.GenericRepository;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto.RiskManagement;
using QualityManagement.Data.Entities;
using QualityManagement.Data.Resources;
using QualityManagement.Domain;
using System;
using System.Linq;
using System.Threading.Tasks;

namespace QualityManagement.Repository.RiskManagment;
public class RiskLogRepository(IUnitOfWork<QMSDbContext> _uow,
    IPropertyMappingService _propertyMappingService ) : GenericRepository<RiskLog, QMSDbContext>(_uow), IRiskLogRepository
{
    public async Task<RiskLogList> GetRiskLog(RiskLogResource riskLogResource)
    {
        var collectionBeforePaging = AllIncluding(c => c.AssignedTo, c => c.CreatedByUser, c => c.RiskCategory);

        collectionBeforePaging = collectionBeforePaging.ApplySort(riskLogResource.OrderBy,
       _propertyMappingService.GetPropertyMapping<RiskLogDto, RiskLog>());

        if (!string.IsNullOrWhiteSpace(riskLogResource.Title))
        {
            collectionBeforePaging = collectionBeforePaging
            .Where(c => c.Title.Contains(riskLogResource.Title));
        }
        if (!string.IsNullOrWhiteSpace(riskLogResource.Description))
        {
            collectionBeforePaging = collectionBeforePaging
            .Where(c => c.Description.Contains(riskLogResource.Description));
        }
        if (riskLogResource.RiskCategoryId.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
          .Where(c => c.RiskCategoryId == riskLogResource.RiskCategoryId);
        }
        if (riskLogResource.AssignedToId.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
          .Where(c => c.AssignedToId == riskLogResource.AssignedToId);
        }
        if (riskLogResource.CreatedBy.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
          .Where(c => c.CreatedBy == riskLogResource.CreatedBy);
        }
        if (riskLogResource.RiskScore.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
          .Where(c => c.RiskScore == riskLogResource.RiskScore);
        }
        if (!string.IsNullOrWhiteSpace(riskLogResource.RiskLevel))
        {
            collectionBeforePaging = collectionBeforePaging
            .Where(c => c.RiskLevel == riskLogResource.RiskLevel);
        }
        if (riskLogResource.Status.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
          .Where(c => c.Status == riskLogResource.Status);
        }
        if (riskLogResource.LogStatus.HasValue)
        {
            collectionBeforePaging = collectionBeforePaging
          .Where(c => c.LogStatus == riskLogResource.LogStatus);
        }
        if (riskLogResource.CreatedFromDate.HasValue && riskLogResource.CreatedToDate.HasValue)
        {
            var startDate = riskLogResource.CreatedFromDate.Value;
            var endDate = riskLogResource.CreatedToDate.Value;

            DateTime minDate = new DateTime(startDate.Year, startDate.Month, startDate.Day, 0, 0, 0);
            DateTime maxDate = new DateTime(endDate.Year, endDate.Month, endDate.Day, 23, 59, 59);

            collectionBeforePaging = collectionBeforePaging
                        .Where(c => c.CreatedDate >= minDate &&
                            c.CreatedDate <= maxDate);
        }


        var riskLogList = new RiskLogList();
        return await riskLogList.Create(
            collectionBeforePaging,
            riskLogResource.Skip,
            riskLogResource.PageSize);

    }
}

