﻿using Microsoft.EntityFrameworkCore;
using QualityManagement.Common.GenericRepository;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data;
using QualityManagement.Domain;
using System.Threading.Tasks;

namespace QualityManagement.Repository
{
    public class RoleRepository(IUnitOfWork<QMSDbContext> uow) : GenericRepository<Role, QMSDbContext>(uow),
          IRoleRepository
    {
        public async Task<Role> GetRoleByUserType(UserType userType)
        {
            string roleName = string.Empty;
            switch (userType)
            {
                case UserType.Employee:
                    roleName = "Employee";
                    break;
                case UserType.CompanyAdmin:
                    roleName = "Company Admin";
                    break;
                case UserType.Administrator:
                    roleName = "Administrator";
                    break;
                default:
                    break;
            }
            if (string.IsNullOrWhiteSpace(roleName))
            {
                return null;
            }

            return await All.FirstOrDefaultAsync(c => c.Name.ToLower() == roleName.ToLower());
        }

    }
}