﻿using System;
using System.Collections.Generic;
using System.Threading.Tasks;
using QualityManagement.Common.GenericRepository;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Resources;

namespace QualityManagement.Repository;

public interface IUserNotificationRepository : IGenericRepository<UserNotification>
{
    void CreateUsersDocumentNotifiction(List<Guid> userIds, Guid documentId);
    Task<List<User>> CreateRolesDocumentNotifiction(List<Guid> roleIds, Guid documentId);
    Task<NotificationList> GetUserNotifications(NotificationResource documentResource);
    Task MarkAsRead(Guid notificationId);
    Task MarkAsReadByDocumentId(Guid documentId);
    Task MarkAllAsRead();
    void AddUserNotificationByReminderScheduler(ReminderScheduler reminderScheduler);
    Task SendNotification(Guid userId);
    Task SendNotification(List<Guid> userIds);
    void createWorkflowInstanceNotifications(List<NotificationWorkflowDto> NotificationWorkflowDtos);
    void AddUserNotificationByAudit(NotificationAuditDto notificationAudit);
    void CreateUserNotificationFileRequestDocument(Guid userId, Guid fileRequestDocumentId, string fileRequestSubject, string fileRequestName);

    void CreateUsersCategoryNotifiction(List<Guid> userIds, Guid categoryId, string sharedByUserName, string categoryName);
    Task<List<User>> CreateRolesCategoryNotifiction(List<Guid> roleIds, Guid categoryId, string sharedByUserName, string categoryName);
    Task NotifiedUsersPermission(List<Guid> userIds);
    void AddUserAsignedNewCourseNotification(Guid courseId, Guid userId, string course);
    void AddAssigmentNotifcation(UserNotificationDto userNotification);
}
