﻿using Microsoft.EntityFrameworkCore;
using QualityManagement.Common.GenericRepository;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data;
using QualityManagement.Domain;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace QualityManagement.Repository
{
    public class UserRoleRepository(IUnitOfWork<QMSDbContext> uow) : GenericRepository<UserRole, QMSDbContext>(uow),
       IUserRoleRepository
    {
        public async Task<List<Guid>> GetUsersByRoles(List<Guid> roleIds)
        {
            return await All.Where(c => roleIds.Contains(c.RoleId)).Select(c => c.UserId).Distinct().ToListAsync();
        }

        public async Task<List<User>> GetUserDetailsByRoles(List<Guid> roleIds)
        {
            return await All.Include(c => c.User).Where(c => roleIds.Contains(c.RoleId)).Select(c => c.User).Distinct().ToListAsync();
        }
    }
}
