﻿using Microsoft.EntityFrameworkCore;
using QualityManagement.Common.GenericRepository;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Resources;
using QualityManagement.Domain;
using System;
using System.Linq;
using System.Threading.Tasks;

namespace QualityManagement.Repository
{
    public class WorkflowTransitionInstanceRepository(
        IUnitOfWork<QMSDbContext> uow,
        IPropertyMappingService _propertyMappingService) : GenericRepository<WorkflowTransitionInstance, QMSDbContext>(uow), IWorkflowTransitionInstanceRepository
    {

        public async Task<WorkflowLogList> GetWorkflowTransitionInstance(WorkflowLogResource workflowLogResource)
        {
            var collectionBeforePaging = All
                .Include(w => w.WorkflowInstance)
                    .ThenInclude(w => w.Workflow)
                .Include(w => w.WorkflowInstance)
                    .ThenInclude(w => w.Document)
                    .IgnoreQueryFilters()
                .Include(w => w.WorkflowInstance)
                    .ThenInclude(w => w.InitiatedBy)
                .Include(w => w.WorkflowTransition)
                    .ThenInclude(w => w.FromWorkflowStep)
                .Include(w => w.WorkflowTransition)
                    .ThenInclude(w => w.ToWorkflowStep)
                .Include(w => w.PerformBy).AsQueryable();


            collectionBeforePaging = collectionBeforePaging.ApplySort(workflowLogResource.OrderBy,
                _propertyMappingService.GetPropertyMapping<WorkflowTransitionLogDto, WorkflowTransitionInstance>());

            if (!string.IsNullOrWhiteSpace(workflowLogResource.WorkflowId))
            {
                collectionBeforePaging = collectionBeforePaging.
                    Where(c => c.WorkflowInstance.Workflow.Id == Guid.Parse(workflowLogResource.WorkflowId));
            }
            if (!string.IsNullOrWhiteSpace(workflowLogResource.DocumentId))
            {
                collectionBeforePaging = collectionBeforePaging
                    .Where(c => c.WorkflowInstance.Document.Id == Guid.Parse(workflowLogResource.DocumentId));

            }
            if (workflowLogResource.WorkflowInstanceStatus != WorkflowInstanceStatus.All)
            {
                collectionBeforePaging = collectionBeforePaging
                    .Where(c => c.WorkflowInstance.Status == workflowLogResource.WorkflowInstanceStatus);
            }

            var workflowLogList = new WorkflowLogList();
            return await workflowLogList.Create(
                collectionBeforePaging,
                workflowLogResource.Skip,
                workflowLogResource.PageSize
                );
        }
    }
}