import { Component, inject, OnInit, signal } from '@angular/core';
import { NavigationCancel, NavigationEnd, NavigationError, NavigationStart, Router, RouterOutlet } from '@angular/router';
import { CommonService } from '@core/services/common.service';
import { LoadingService } from '@shared/loading-indicator/loading-service';
import { LoadingIndicatorComponent } from "@shared/loading-indicator/loading-indicator.component";

@Component({
  selector: 'app-root',
  imports: [RouterOutlet, LoadingIndicatorComponent],
  templateUrl: './app.html',
  styleUrl: './app.scss'
})
export class App implements OnInit {
  protected readonly title = signal('qms_new');
  private commonService = inject(CommonService);
  private loadingService = inject(LoadingService);
  private router = inject(Router);

  ngOnInit(): void {
    this.router.events.subscribe(event => {
      if (event instanceof NavigationStart) {
        this.loadingService.setLoadingFlag(true);
      }
      if ((event instanceof NavigationError || event instanceof NavigationEnd || event instanceof NavigationCancel)) {
        this.loadingService.setLoadingFlag(false);
      }
    });
    this.getAllAllowFileExtension();
  }

  getAllAllowFileExtension() {
    this.commonService.getAllowFileExtensions().subscribe();
  }
}
