import { Component, inject, OnInit } from '@angular/core';
import { TranslateModule } from '@ngx-translate/core';
import { AuditTemplate } from './models/audit-template';
import { AuditTemplateService } from './audit-template-service';
import { Router, RouterModule } from '@angular/router';
import { MatCardModule } from '@angular/material/card';
import { MatButtonModule } from '@angular/material/button';
import { MatIconModule } from '@angular/material/icon';
import { MatDialog } from '@angular/material/dialog';
import { StartAuditComponent } from './start-audit/start-audit.component';
import { HasClaimDirective } from '@shared/has-claim.directive'

@Component({
  selector: 'app-audit-template-list',
  imports: [
    TranslateModule,
    RouterModule,
    MatCardModule,
    MatButtonModule,
    MatIconModule,
    HasClaimDirective
  ],
  templateUrl: './audit-template-list.component.html',
  styleUrl: './audit-template-list.component.scss',
})
export class AuditTemplateListComponent implements OnInit {
  templates: AuditTemplate[] = [];

  auditTemplateService = inject(AuditTemplateService);
  dialog = inject(MatDialog);
  router = inject(Router);

  ngOnInit(): void {
    this.getAllTemplates();
  }
  getAllTemplates(): void {
    this.auditTemplateService.getAllTemplates().subscribe({
      next: (templates: AuditTemplate[]) => {
        if (templates && templates.length > 0) {
          this.templates = [...templates];
        } else {
          console.error('Error fetching templates:', templates);
        }
      },
      error: (error) => {
        console.error('Error fetching templates:', error);
      }
    });
  }

  startAudit(auditTemplateId: string): void {
    this.dialog.open(StartAuditComponent, {
      data: { auditTemplateId },
    });
  }

  previewTemplate(id: string): void {
    this.router.navigate(['/audit/audit-template', id]);
  }
}
