import { inject, Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { CommonHttpErrorService } from '@core/error-handler/common-http-error.service';
import { catchError, Observable } from 'rxjs';
import { Department } from '@core/domain-classes/department';
import { CommonError } from '@core/error-handler/common-error';

@Injectable({ providedIn: 'root' })
export class DepartmentService {
  private commonHttpErrorService = inject(CommonHttpErrorService);
  private httpClient = inject(HttpClient);

  getDepartments(): Observable<Department[]> {
    const url = 'department';
    return this.httpClient.get<Department[]>(url);
  }
  getDepartmentById(id: string): Observable<Department | CommonError> {
    const url = `department/${id}`;
    return this.httpClient.get<Department>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  addDepartment(department: Department): Observable<Department | CommonError> {
    const url = `department`;
    return this.httpClient.post<Department>(url, department)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  updateDepartment(department: Department): Observable<Department | CommonError> {
    const url = `department/${department.id}`;
    return this.httpClient.put<Department>(url, department)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  deleteDepartment(id: string): Observable<void | CommonError> {
    const url = `department/${id}`;
    return this.httpClient.delete<void>(url).pipe(
      catchError(this.commonHttpErrorService.handleError)
    );
  }
}
