import { Component, Inject, inject, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, ReactiveFormsModule, Validators } from '@angular/forms';
import { MAT_DIALOG_DATA, MatDialogModule, MatDialogRef } from '@angular/material/dialog';
import { TranslateModule } from '@ngx-translate/core';
import { DepartmentStore } from '../store/department.store';
import { ActivatedRoute } from '@angular/router';
import { Department } from '@core/domain-classes/department';
import { BaseComponent } from '../../../base.component';
import { toObservable } from '@angular/core/rxjs-interop';
import { MatIconModule } from '@angular/material/icon';
import { MatButtonModule } from '@angular/material/button';
import { MatCardModule } from '@angular/material/card';

@Component({
  selector: 'app-manage-department',
  imports: [
    TranslateModule,
    ReactiveFormsModule,
    MatDialogModule,
    MatIconModule,
    MatButtonModule,
    MatCardModule
  ],
  templateUrl: './manage-department.component.html',
  styleUrl: './manage-department.component.scss'
})
export class ManageDepartmentComponent extends BaseComponent implements OnInit {
  departmentForm!: FormGroup;
  dialogRef = inject(MatDialogRef<ManageDepartmentComponent>);
  fb = inject(FormBuilder);
  departmentStore = inject(DepartmentStore);
  route = inject(ActivatedRoute);
  isEdit = false;

  constructor(
    @Inject(MAT_DIALOG_DATA) public departmentDetails: Department,
  ) {
    super();
    this.subscribeIsAddorUpdate();
  }

  ngOnInit(): void {
    this.creatDepartmentForm();
    if (this.departmentDetails) {
      this.isEdit = true;
      this.departmentForm.patchValue(this.departmentDetails)
    }
  }

  creatDepartmentForm() {
    this.departmentForm = this.fb.group(
      {
        id: [''],
        name: ['', [Validators.required]],
        description: [''],
      }
    );
  }

  onSubmit() {
    if (!this.departmentForm.valid) {
      this.departmentForm.markAllAsTouched();
      return;
    }
    if (this.isEdit) {
      this.departmentStore.updateDepartment(this.departmentForm.getRawValue());
    } else {
      this.departmentStore.addDepartment(this.departmentForm.getRawValue());
    }
  }

  onNoClick(department?: Department | null): void {
    this.dialogRef.close(department);
  }

  subscribeIsAddorUpdate() {
    toObservable(this.departmentStore.isAddUpdate).subscribe((flag) => {
      if (flag) {
        this.onNoClick(this.departmentStore.department());
      }
      this.departmentStore.resetflag();
    })
  }
}
