import { Component, inject, Inject, OnInit } from '@angular/core';
import {
  ReactiveFormsModule,
  UntypedFormBuilder,
  UntypedFormGroup,
  Validators,
} from '@angular/forms';
import { MatButtonModule } from '@angular/material/button';
import {
  MAT_DIALOG_DATA,
  MatDialogModule,
  MatDialogRef,
} from '@angular/material/dialog';
import { MatSelectModule } from '@angular/material/select';
import { Router } from '@angular/router';
import { StartAudit } from '@core/domain-classes/audit';

import { ToastrService } from '@core/services/toastr-service';
import { AuditService } from '../../audit/audit.service';
import { BaseComponent } from '../../base.component';
import { AUDIT_STATUS } from '../models/audit-status';
import { AuditStore } from '../../audit/audit-store';
import { UserStore } from '../../user/store/user.store';
import { PageHelpTextComponent } from '@shared/page-help-text/page-help-text.component';
import { TranslateModule } from '@ngx-translate/core';
import { MatIconModule } from '@angular/material/icon';
import { MatCardModule } from '@angular/material/card';
@Component({
  selector: 'app-start-audit',
  imports: [
    MatDialogModule,
    ReactiveFormsModule,
    MatButtonModule,
    MatSelectModule,
    PageHelpTextComponent,
    TranslateModule,
    MatIconModule,
    MatCardModule
  ],
  templateUrl: './start-audit.component.html',
  styleUrl: './start-audit.component.scss',
})
export class StartAuditComponent extends BaseComponent implements OnInit {
  auditForm: UntypedFormGroup;
  userStore = inject(UserStore);
  auditStore = inject(AuditStore);
  constructor(
    private fb: UntypedFormBuilder,
    private toastrService: ToastrService,
    private dialogRef: MatDialogRef<StartAuditComponent>,
    @Inject(MAT_DIALOG_DATA) public data: { auditTemplateId: string },
    private auditService: AuditService,
    private router: Router
  ) {
    super();
    this.data = { auditTemplateId: data.auditTemplateId };
  }
  ngOnInit(): void {
    this.createForm();
  }

  createForm(): void {
    this.auditForm = this.fb.group({
      auditorId: ['', [Validators.required]],
      auditTemplateId: [this.data.auditTemplateId],
      title: ['', [Validators.required]]
    });
  }

  saveAudit(): void {
    if (this.auditForm.invalid) {
      this.auditForm.markAllAsTouched();
      return;
    }

    const auditorId = this.auditForm.get('auditorId')?.value;

    const audit: StartAudit = {
      auditorId: auditorId,
      auditTemplateId: this.data.auditTemplateId,
      status: AUDIT_STATUS.CREATED,
      title: this.auditForm.get('title')?.value,
    };
    this.auditStore.addAudit(audit);
    this.dialogRef.close();
  }

  closeDialog() {
    this.dialogRef.close();
  }
}
