import { AbstractControl, ValidationErrors, ValidatorFn } from "@angular/forms";

export function compareOptionValidator(): ValidatorFn {
  return (group: AbstractControl): ValidationErrors | null => {
    const optionValue = group.get('optionValue')?.value;
    const optionText = group.get('optionText')?.value;
    if (optionValue && optionText && parseInt(optionText) > parseInt(optionValue)) {
      return { invalidratingrange: true }; // or your custom error key
    }
    return null;
  };
}
