import { HttpResponse, HttpParams, HttpClient } from '@angular/common/http';
import { inject, Injectable } from '@angular/core';
import { Audit } from '@core/domain-classes/audit';
import { CommonError } from '@core/error-handler/common-error';
import { Observable, catchError } from 'rxjs';
import { AuditResource } from '../audit-resource';
import { CommonHttpErrorService } from '@core/error-handler/common-http-error.service';
import { AuditResponseLog } from '@core/domain-classes/audit-response-log';

@Injectable({
  providedIn: 'root'
})
export class AuditLogService {
  private httpClient = inject(HttpClient);
  private commonHttpErrorService = inject(CommonHttpErrorService)
  constructor() { }

  getAuditResponseLogs(
    resource: AuditResource
  ): Observable<HttpResponse<AuditResponseLog[]>> {
    const url = 'AuditResponseLog';
    const customParams = new HttpParams()
      .set('OrderBy', resource.orderBy)
      .set('PageSize', resource.pageSize)
      .set('Skip', resource.skip)
      .set('AuditTemplateName', resource.auditTemplateName)
      .set('Title', resource.title)
      .set('AuditorId', resource.auditorId ?? '')
      .set('DepartmentId', resource.departmentId ?? '')
      .set('AuditStatus', resource.auditStatus ?? '')
      .set('AuditType', resource.auditType ?? '')
      .set('LogStatus', resource.logStatus ?? '');
    return this.httpClient
      .get<AuditResponseLog[]>(url, {
        params: customParams,
        observe: 'response',
      });

  }
}
