import { Component, Input } from '@angular/core';
import { MatTableModule } from '@angular/material/table';
import { RouterModule } from '@angular/router';
import { CapaRequest } from '../../../capa/model/capa-request';
import { TranslateModule } from '@ngx-translate/core';
import { LimitToPipe } from '@shared/pipes/limit-to.pipe';
import { MatCardModule } from '@angular/material/card';
import { NgClass } from '@angular/common';

@Component({
  selector: 'app-total-capa-list-details',
  imports: [
    MatTableModule,
    RouterModule,
    TranslateModule,
    LimitToPipe,
    MatCardModule,
    NgClass
  ],
  templateUrl: './total-capa-list-details.component.html',
  styleUrl: './total-capa-list-details.component.scss',
})
export class TotalCapaListDetailsComponent {
  @Input() capaRequests: CapaRequest[] = [];
  displayedColumns: string[] = ['referenceNo', 'title', 'status'];

  isOddDataRow(index: number): boolean {
    // index = the index in dataSource, not in DOM
    return index % 2 !== 0;
  }

  getDataIndex(row: any) {
    return this.capaRequests.indexOf(row);
  }
}
