import { Component, Input } from '@angular/core';
import { MatTableModule } from '@angular/material/table';
import { RouterModule } from '@angular/router';
import { NonConformance } from '../../../non-conformance/model/non-conformance';
import { TranslateModule } from '@ngx-translate/core';
import { LimitToPipe } from '@shared/pipes/limit-to.pipe';
import { MatCardModule } from '@angular/material/card';
import { NgClass } from '@angular/common';

@Component({
  selector: 'app-total-non-conformance-list-details',
  imports: [
    MatTableModule,
    RouterModule,
    TranslateModule,
    LimitToPipe,
    MatCardModule,
    NgClass
  ],
  templateUrl: './total-non-conformance-list-details.component.html',
  styleUrl: './total-non-conformance-list-details.component.scss',
})
export class TotalNonConformanceListDetailsComponent {
  @Input() nonConformances: NonConformance[] = [];
  displayedColumns: string[] = ['ncNumber', 'title', 'status'];

  isOddDataRow(index: number): boolean {
    // index = the index in dataSource, not in DOM
    return index % 2 !== 0;
  }

  getDataIndex(row: any) {
    return this.nonConformances.indexOf(row);
  }
}
