import { Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { catchError, Observable, } from 'rxjs';
import { CommonError } from '@core/error-handler/common-error';
import { AuditReview, SubmitAudit } from '@core/domain-classes/audit';
import { CommonHttpErrorService } from '@core/error-handler/common-http-error.service';

@Injectable({ providedIn: 'root' })
export class AuditReviewService {
  maxRetries: number = 2;
  constructor(
    private commonHttpErrorService: CommonHttpErrorService,
    private httpClient: HttpClient
  ) { }

  submitAuditReview(auditReview: AuditReview): Observable<AuditReview | CommonError> {
    const url = `AuditReview`;
    return this.httpClient
      .post<AuditReview>(url, auditReview)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

}
