import { Component, inject, Input, OnInit } from '@angular/core';
import { MatTableModule } from '@angular/material/table';
import { AuditReviewer } from '@core/domain-classes/audit-reviewer';
import { TranslateModule } from '@ngx-translate/core';
import { AuditStatusPipe } from '../audit-status.pipe';
import { AuditService } from '../audit.service';
import { UTCToLocalTime } from '@shared/pipes/utc-to-localtime.pipe';
import { AUDIT_STATUS } from '../../audit-template/models/audit-status';
import { NgClass } from '@angular/common';
import { MatCardModule } from '@angular/material/card';

@Component({
  selector: 'app-audit-reviewers',
  imports: [
    MatTableModule,
    TranslateModule,
    AuditStatusPipe,
    UTCToLocalTime,
    NgClass,
    MatCardModule
  ],
  templateUrl: './audit-reviewers.component.html',
  styleUrls: ['./audit-reviewers.component.scss'],
  standalone: true,
})
export class AuditReviewersComponent implements OnInit {

  AUDIT_STATUS = AUDIT_STATUS;
  auditReviewers: AuditReviewer[] = [];
  auditService = inject(AuditService);
  displayedColumns: string[] = ['submitterName', 'reviewerName', 'reviewedOn', 'auditStatus', 'comments'];
  @Input() auditId: string;

  ngOnInit(): void {
    this.loadAuditReviewers();
  }

  private loadAuditReviewers(): void {
    this.auditService.getAuditReviewersById(this.auditId)
      .subscribe((reviewers: AuditReviewer[]) => {
        this.auditReviewers = reviewers;
      });
  }

  isOddDataRow(index: number): boolean {
    // index = the index in dataSource, not in DOM
    return index % 2 !== 0;
  }

  getDataIndex(row: any) {
    return this.auditReviewers.indexOf(row);
  }
}
