import { Routes } from "@angular/router";
import { AuthGuard } from "@core/security/auth.guard";

export const AUDIT_ROUTES: Routes = [
  {
    path: 'logs',
    canMatch: [AuthGuard],
    data: { claimType: 'MANAGE_AUDIT_LOGS' },
    loadComponent: () =>
      import('./audit-log-list/audit-log-list.component').then(
        (c) => c.AuditLogListComponent
      ),
  },
  {
    path: 'audit-list',
    canMatch: [AuthGuard],
    data: { claimType: 'VIEW_AUDIT' },
    loadComponent: () =>
      import('./audit-list/audit-list.component').then(
        (c) => c.AuditListComponent
      ),
  },
  {
    path: 'audit-for-review',
    canMatch: [AuthGuard],
    data: { claimType: 'VIEW_AUDIT_FOR_REVIEW' },
    loadComponent: () =>
      import('./audit-for-review-list/audit-for-review-list.component').then(
        (c) => c.AuditForReviewListComponent
      ),
  },
  {
    path: 'audit-template',
    canMatch: [AuthGuard],
    data: { claimType: 'VIEW_AUDIT_TEMPLATE' },
    loadComponent: () =>
      import('../audit-template/audit-template-list.component').then(
        (c) => c.AuditTemplateListComponent
      ),
  },
  {
    path: 'audit-template/:id',
    loadComponent: () =>
      import('../audit-template/audit-template.component').then(
        (c) => c.AuditTemplateComponent
      ),
  },
  {
    path: 'report/:id',
    canMatch: [AuthGuard],
    data: { claimType: 'DOWNLOAD_AUDIT_REPORT' },
    loadComponent: () =>
      import('./audit-report/audit-report.component').then(
        (c) => c.AuditReportComponent
      ),
  },
  {
    path: ':id',
    loadComponent: () =>
      import('./audit.component').then((c) => c.AuditComponent),
  },
];
