import { Pipe, PipeTransform } from '@angular/core';
import { TranslateService } from '@ngx-translate/core';
import { AUDIT_STATUS } from '../audit-template/models/audit-status';
import { TranslationService } from '@core/services/translation.service';

@Pipe({
  name: 'auditStatus',
  standalone: true
})

export class AuditStatusPipe implements PipeTransform {
  constructor(
    private translationService: TranslationService
  ) { }
  transform(value: any, ...args: any[]): string | any {
    if (value === null || value === undefined) {
      return '';
    }
    if (value == AUDIT_STATUS.CREATED) {
      return this.translationService.getValue('CREATED');
    } else if (value == AUDIT_STATUS.INPROGRESS) {
      return this.translationService.getValue('INPROGRESS');
    } else if (value == AUDIT_STATUS.COMPLETED) {
      return this.translationService.getValue('COMPLETED');
    } else if (value == AUDIT_STATUS.CLOSED) {
      return this.translationService.getValue('CLOSED');
    } else if (value == AUDIT_STATUS.INREVIEW) {
      return this.translationService.getValue('SUBMITTED_FOR_REVIEW');
    } else if (value == AUDIT_STATUS.REJECTED) {
      return this.translationService.getValue('REJECTED');
    } else if (value == AUDIT_STATUS.REWORK) {
      return this.translationService.getValue('SEND_FOR_REWORK');
    }
  }
}
