import { Pipe, PipeTransform } from '@angular/core';
import { AUDIT_TYPE } from '../audit-template/models/audit-type';
import { TranslationService } from '@core/services/translation.service';

@Pipe({
  name: 'audittypepipe',
  standalone: true
})

export class AuditTypePipe implements PipeTransform {
  constructor(
    private translationService: TranslationService
  ) { }
  transform(value: any, ...args: any[]): any {
    if (value == AUDIT_TYPE.INTERNAL) {
      return this.translationService.getValue('INTERNAL_AUDIT');
    } else if (value == AUDIT_TYPE.EXTERNAL) {
      return this.translationService.getValue('EXTERNAL_AUDIT');
    } else if (value == AUDIT_TYPE.SUPPLIER) {
      return this.translationService.getValue('SUPPLIER_AUDIT');
    } else if (value == AUDIT_TYPE.ALL) {
      return this.translationService.getValue('ALL');
    } else {
      return this.translationService.getValue('UNKNOWN_AUDIT_TYPE');
    }
  }
}
