import { Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { catchError, Observable, } from 'rxjs';
import { CommonError } from '@core/error-handler/common-error';
import { SubmitAudit } from '@core/domain-classes/audit';
import { CommonHttpErrorService } from '@core/error-handler/common-http-error.service';

@Injectable({ providedIn: 'root' })
export class AuditReviewerService {
  maxRetries: number = 2;
  constructor(
    private commonHttpErrorService: CommonHttpErrorService,
    private httpClient: HttpClient
  ) { }

  submitAudit(audit: SubmitAudit): Observable<SubmitAudit | CommonError> {
    const url = `AuditReviewer`;
    return this.httpClient
      .post<SubmitAudit>(url, audit)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }
}
