import { inject, Injectable } from '@angular/core';
import { CommonError } from '@core/error-handler/common-error';
import { CommonHttpErrorService } from '@core/error-handler/common-http-error.service';
import { Observable, catchError } from 'rxjs';
import { CapaAction } from '../model/capa-action';
import { HttpClient } from '@angular/common/http';
import { CapaRequest } from '../model/capa-request';

@Injectable({
  providedIn: 'root'
})
export class CapaActionService {
  private httpClient = inject(HttpClient);
  private commonHttpErrorService = inject(CommonHttpErrorService);
  constructor() { }

  getCapaActionsByRequestId(capaRequestId: string): Observable<CapaAction[] | CommonError> {
    const url = `CapaAction/${capaRequestId}`;
    return this.httpClient
      .get<CapaAction[]>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  getUserCapaActions(): Observable<CapaRequest[] | CommonError> {
    const url = 'CapaAction/asigned/actions';
    return this.httpClient
      .get<CapaRequest[]>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  addCapaAction(setting: CapaAction): Observable<CapaAction> {
    const url = 'CapaAction';
    return this.httpClient
      .post<CapaAction>(url, setting);
  }

  updateCapaAction(setting: CapaAction): Observable<CapaAction | CommonError> {
    const url = `CapaAction/${setting.id}`;
    return this.httpClient
      .put<CapaAction>(url, setting)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  deleteCapaAction(id: string): Observable<CapaAction | CommonError> {
    const url = `CapaAction/${id}`;
    return this.httpClient
      .delete<CapaAction>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }
}
