import { Component, inject, OnInit } from '@angular/core';
import { MatCardModule } from '@angular/material/card';
import { MatButtonModule } from '@angular/material/button';
import { MatIconModule } from '@angular/material/icon';
import { MatTooltipModule } from '@angular/material/tooltip';
import { NgClass } from '@angular/common';
import { TranslateModule } from '@ngx-translate/core';
import { UTCToLocalTime } from '@shared/pipes/utc-to-localtime.pipe';
import { CapaActionTypePipe } from '../../pipes/capa-action-type.pipe';
import { CapaActionStatusPipe } from '../../pipes/capa-action-status.pipe';
import { CapaRequestStatusPipe } from '../../pipes/capa-request-status.pipe';
import { CapaRequestPriorityPipe } from '../../pipes/capa-request-priority.pipe';
import { BaseComponent } from '../../../base.component';
import { CapaActionService } from '../capa-action.service';
import { ToastrService } from '@core/services/toastr-service';
import { PageHelpTextComponent } from "@shared/page-help-text/page-help-text.component";
import { CapaRequest } from '../../model/capa-request';
import { FormsModule } from '@angular/forms';
import { TextEditorComponent } from "@shared/text-editor/text-editor.component";
import { CapaAction } from '../../model/capa-action';
import { TranslationService } from '@core/services/translation.service';
import { CommonDialogService } from '@core/common-dialog/common-dialog.service';
import { CAPA_ACTION_STATUS } from '../../model/capa-action-status-enum';
import { CAPA_ACTION_TYPE } from '../../model/capa-action-type-enum';
import { CAPA_REQUEST_STATUS } from '../../model/capa-Request-Status-enum';
import { CAPA_REQUEST_PRIORITY } from '../../model/capa-Request-Priority-enum';

@Component({
  selector: 'app-user-capa-action-list',
  imports: [
    MatCardModule,
    MatButtonModule,
    MatIconModule,
    MatTooltipModule,
    NgClass,
    TranslateModule,
    UTCToLocalTime,
    CapaActionTypePipe,
    CapaActionStatusPipe,
    CapaRequestStatusPipe,
    CapaRequestPriorityPipe,
    PageHelpTextComponent,
    FormsModule,
    TextEditorComponent
  ],
  templateUrl: './my-capa-action-list.html',
  styleUrl: './my-capa-action-list.scss'
})
export class MyCapaActionList extends BaseComponent implements OnInit {
  capaRequest: CapaRequest[] = [];
  expandedIndex: number | null = null;
  CAPA_ACTION_STATUS = CAPA_ACTION_STATUS;
  CAPA_ACTION_TYPE = CAPA_ACTION_TYPE;
  CAPA_REQUEST_STATUS = CAPA_REQUEST_STATUS;
  CAPA_REQUEST_PRIORITY = CAPA_REQUEST_PRIORITY;

  private capaActionService = inject(CapaActionService);
  private toastrService = inject(ToastrService);
  private translateService = inject(TranslationService);
  commonDialogService = inject(CommonDialogService);

  ngOnInit(): void {
    this.loadUserCapaActions();
  }

  loadUserCapaActions(): void {
    this.sub$.sink = this.capaActionService.getUserCapaActions().subscribe({
      next: (actions: CapaRequest[] | any) => {
        const capaActions = actions as CapaRequest[];
        if (capaActions) {
          this.capaRequest = capaActions;
        }
      }
    });
  }

  updateActionStatus(action: CapaAction, newStatus: number): void {
    const capaActions: CapaAction = { ...action, status: newStatus };

    this.sub$.sink = this.commonDialogService
      .deleteConfirmtionDialog(`${this.translateService.getValue('ARE_YOU_SURE_YOU_WANT_TO_UPDATE_STATUS')}`)
      .subscribe((isTrue: boolean) => {
        if (isTrue) {
          this.capaActionService.updateCapaAction(capaActions).subscribe({
            next: (res) => {
              const updatedAction = res as CapaAction;
              if (updatedAction) {
                action.status = updatedAction.status;
                this.toastrService.success(this.translateService.getValue('CAPA_ACTION_UPDATED_SUCCESSFULLY'));
              }
            }
          });
        }
      });
  }

  onAccordionToggle(index: number) {
    this.expandedIndex = this.expandedIndex === index ? null : index;
  }
}
