import { Component, inject, OnInit } from '@angular/core';
import { MatTabsModule } from '@angular/material/tabs';
import { ActivatedRoute, NavigationEnd, ParamMap, Router, RouterModule, RouterOutlet } from '@angular/router';
import { TranslateModule } from '@ngx-translate/core';
import { HasClaimDirective } from '@shared/has-claim.directive';
import { PageHelpTextComponent } from '@shared/page-help-text/page-help-text.component';
import { BaseComponent } from '../../base.component';
import { filter } from 'rxjs/operators';

@Component({
  selector: 'app-capa-manage',
  standalone: true,
  imports: [
    MatTabsModule,
    RouterOutlet,
    PageHelpTextComponent,
    TranslateModule,
    HasClaimDirective,
    RouterModule
  ],
  templateUrl: './capa-details.component.html',
  styleUrl: './capa-details.component.scss'
})
export class CapaDetailsComponent extends BaseComponent implements OnInit {
  router = inject(Router);
  route = inject(ActivatedRoute);
  selectedTabIndex = 0;
  capaRequestId: string | null = null;

  ngOnInit(): void {
    // Get capaRequestId dynamically from route (parent or self)
    this.route.paramMap.subscribe((params: ParamMap) => {
      this.capaRequestId = params.get('id');
    });

    // Listen to route changes to set tab index properly
    this.sub$.sink = this.router.events.subscribe(event => {
      if (event instanceof NavigationEnd) {
        this.setTabIndexFromUrl(event.urlAfterRedirects);
      }
    });

    this.setTabIndexFromUrl(this.router.url);
  }

  setTabIndexFromUrl(url: string) {
    if (url.includes('root/cause')) {
      this.selectedTabIndex = 2;
    } else if (url.includes('review')) {
      this.selectedTabIndex = 1;
    } else if (url.includes('attachment')) {
      this.selectedTabIndex = 4;
    } else if (url.includes('action')) {
      this.selectedTabIndex = 3;
    } else if (url.includes('/capa/details')) {
      this.selectedTabIndex = 0;
    }
  }

  onTabChange(index: number) {
    if (!this.capaRequestId) return; // prevent navigation without id

    switch (index) {
      case 0:
        this.router.navigate(['/capa/details', this.capaRequestId], {
          queryParams: { isDetailsMode: true }
        });
        break;
      case 1:
        this.router.navigate(['/capa/details', this.capaRequestId, 'review']);
        break;
      case 2:
        this.router.navigate(['/capa/details', this.capaRequestId, 'root', 'cause']);
        break;
      case 3:
        this.router.navigate(['/capa/details', this.capaRequestId, 'action']);
        break;
      case 4:
        this.router.navigate(['/capa/details', this.capaRequestId, 'attachment']);
        break;
    }
  }
}
