import { HttpClient, HttpParams, HttpResponse } from '@angular/common/http';
import { inject, Injectable } from '@angular/core';
import { CommonHttpErrorService } from '@core/error-handler/common-http-error.service';
import { Observable } from 'rxjs';
import { CapaRequest } from '../model/capa-request';
import { CapaRequestResource } from '../model/capa-request-resource';

@Injectable({
  providedIn: 'root'
})
export class CapaRequestLogService {
  private httpClient = inject(HttpClient);
  private commonHttpErrorService = inject(CommonHttpErrorService);
  constructor() { }

  getCapaRequests(
    resource: CapaRequestResource
  ): Observable<HttpResponse<CapaRequest[]>> {
    const url = 'CapaRequsetLog';
    const customParams = new HttpParams()
      .set('OrderBy', resource.orderBy)
      .set('PageSize', resource.pageSize)
      .set('Skip', resource.skip)
      .set('ReferenceNo', resource.referenceNo)
      .set('Title', resource.title)
      .set('Priority', resource.priority)
      .set('RaisedById', resource.raisedById)
      .set('AuditId', resource.auditId)
      .set('CapaRequestStatus', resource.capaRequestStatus)
      .set('RaisedById', resource.raisedById)
      .set('DueStartDate', resource.dueStartDate ? resource.dueStartDate.toISOString() : '')
      .set('DueEndDate', resource.dueEndDate ? resource.dueEndDate.toISOString() : '')
      .set('LogStatus', resource.logStatus ?? '');
    return this.httpClient.get<CapaRequest[]>(url, {
      params: customParams,
      observe: 'response'
    });
  }
}
