import { ActivatedRouteSnapshot, ResolveFn } from '@angular/router';
import { CapaRequest } from '../model/capa-request';
import { CapaRequestService } from './capa-request.service';
import { inject } from '@angular/core';
import { Observable } from 'rxjs';

export const CapaRequestResolver: ResolveFn<CapaRequest | undefined> = (route: ActivatedRouteSnapshot) => {
  const capaRequestService = inject(CapaRequestService);
  const id = route.params['id']
  if (id != null) {
    return capaRequestService.getCapaRequestById(id) as Observable<CapaRequest>;
  } return;
};
