import { HttpClient } from '@angular/common/http';
import { inject, Injectable } from '@angular/core';
import { CommonHttpErrorService } from '@core/error-handler/common-http-error.service';
import { catchError, Observable } from 'rxjs';
import { CapaReview } from '../model/capa-review';
import { CommonError } from '@core/error-handler/common-error';

@Injectable({
  providedIn: 'root'
})
export class CapaReviewService {
  private httpClient = inject(HttpClient);
  private commonHttpErrorService = inject(CommonHttpErrorService);
  constructor() { }

  getCapaReviewsById(reviewId: string): Observable<CapaReview[] | CommonError> {
    const url = `CapaReview/${reviewId}`;
    return this.httpClient
      .get<CapaReview[]>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  creatCapaReview(capaReview: CapaReview): Observable<CapaReview | CommonError> {
    const url = 'CapaReview';
    return this.httpClient
      .post<CapaReview>(url, capaReview)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  updateCapaReview(capaReview: CapaReview): Observable<CapaReview | CommonError> {
    const url = `CapaReview/${capaReview.id}`;
    return this.httpClient
      .put<CapaReview>(url, capaReview)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }
}
