import { Component, inject } from '@angular/core';
import { ReactiveFormsModule } from '@angular/forms';
import { MatTableModule } from '@angular/material/table';
import { CommonDialogService } from '@core/common-dialog/common-dialog.service';
import { CapaRootCauseMethodology } from '@core/domain-classes/capa-root-cause-methodology';
import { BaseComponent } from '../../../base.component';
import { CapaRootCauseMethodologyStore } from '../capa-root-cause-methodology-store';
import { MatDialog } from '@angular/material/dialog';
import { ManageCapaRootCauseMethodologyComponent } from '../manage-capa-root-cause-methodology/manage-capa-root-cause-methodology.component';
import { PageHelpTextComponent } from '@shared/page-help-text/page-help-text.component';
import { HasClaimDirective } from '@shared/has-claim.directive';
import { TranslateModule } from '@ngx-translate/core';
import { MatButtonModule } from '@angular/material/button';
import { MatCardModule } from '@angular/material/card';
import { MatIconModule } from '@angular/material/icon';
import { NgClass } from '@angular/common';

@Component({
  selector: 'app-capa-root-cause-methodology-list',
  imports: [
    ReactiveFormsModule,
    MatTableModule,
    PageHelpTextComponent,
    HasClaimDirective,
    TranslateModule,
    MatButtonModule,
    MatCardModule,
    MatIconModule,
    NgClass
  ],
  templateUrl: './capa-root-cause-methodology-list.component.html',
  styleUrl: './capa-root-cause-methodology-list.component.scss'
})
export class CapaRootCauseMethodologyListComponent extends BaseComponent {
  displayedColumns: string[] = ['action', 'name'];
  capaRootCauseMethodologyStore = inject(CapaRootCauseMethodologyStore);
  commonDialogService = inject(CommonDialogService);
  dialog = inject(MatDialog);

  addcapaRootCauseMethodology() {
    this.dialog.open(ManageCapaRootCauseMethodologyComponent, {
      maxWidth: '60vw',
      width: '100%',
      panelClass: 'centered-dialog',
    });
  }

  updatecapaRootCauseMethodology(capaRootCauseMethodology: CapaRootCauseMethodology) {
    this.dialog.open(ManageCapaRootCauseMethodologyComponent, {
      maxWidth: '60vw',
      width: '100%',
      maxHeight: '90vh',
      panelClass: 'centered-dialog',
      data: Object.assign({}, capaRootCauseMethodology)
    })
  }

  deleteCapaRootCauseMethodology(capaRootCauseMethodology: CapaRootCauseMethodology) {
    this.sub$.sink = this.commonDialogService
      .deleteConfirmtionDialog(
        `${this.translationService.getValue(
          'ARE_YOU_SURE_YOU_WANT_TO_DELETE'
        )} ${capaRootCauseMethodology.name}`
      )
      .subscribe((isTrue: boolean) => {
        if (isTrue) {
          this.capaRootCauseMethodologyStore.deleteCapaRootCauseMethodologyById(
            capaRootCauseMethodology.id ?? ''
          );
        }
      });
  }

  refresh() {
    this.capaRootCauseMethodologyStore.loadCapaRootCauseMethodologys();
  }

  isOddDataRow(index: number): boolean {
    // index = the index in dataSource, not in DOM
    return index % 2 !== 0;
  }

  getDataIndex(row: any) {
    return this.capaRootCauseMethodologyStore.capaRootCauseMethodologys().indexOf(row);
  }
}
