import { HttpClient } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { catchError } from 'rxjs/operators';
import { CapaRootCauseMethodology } from '@core/domain-classes/capa-root-cause-methodology';
import { CommonHttpErrorService } from '@core/error-handler/common-http-error.service';
import { CommonError } from '@core/error-handler/common-error';

@Injectable({
  providedIn: 'root',
})
export class CapaRootCauseMethodologyService {
  constructor(
    private httpClient: HttpClient,
    private commonHttpErrorService: CommonHttpErrorService,
  ) {}


  getCapaRootCauseMethodologys(): Observable<CapaRootCauseMethodology[] | CommonError> {
    const url = 'CapaRootCauseMethodology';
    return this.httpClient.get<CapaRootCauseMethodology[]>(url).pipe(
      catchError(this.commonHttpErrorService.handleError)
    );
  }

  getCapaRootCauseMethodology(id: string): Observable<CapaRootCauseMethodology | CommonError> {
    const url = `CapaRootCauseMethodology/${id}`;
    return this.httpClient
      .get<CapaRootCauseMethodology>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  addCapaRootCauseMethodology(
    setting: CapaRootCauseMethodology
  ): Observable<CapaRootCauseMethodology | CommonError> {
    const url = `CapaRootCauseMethodology`;
    return this.httpClient
      .post<CapaRootCauseMethodology>(url, setting)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  updateCapaRootCauseMethodology(
    setting: CapaRootCauseMethodology
  ): Observable<CapaRootCauseMethodology | CommonError> {
    const url = `CapaRootCauseMethodology/${setting.id}`;
    return this.httpClient
      .put<CapaRootCauseMethodology>(url, setting)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  deleteCapaRootCauseMethodology(
    id: string
  ): Observable<CapaRootCauseMethodology | CommonError> {
    const url = `CapaRootCauseMethodology/${id}`;
    return this.httpClient
      .delete<CapaRootCauseMethodology>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }
}
