import { Component, Inject, inject, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, ReactiveFormsModule, Validators } from '@angular/forms';
import { CapaRootCauseMethodology } from '@core/domain-classes/capa-root-cause-methodology';
import { CapaRootCauseMethodologyStore } from '../capa-root-cause-methodology-store';
import { MAT_DIALOG_DATA, MatDialogModule, MatDialogRef } from '@angular/material/dialog';
import { TextEditorComponent } from "../../../shared/text-editor/text-editor.component";
import { TranslateModule } from '@ngx-translate/core';
import { MatButtonModule } from '@angular/material/button';
import { MatCardModule } from '@angular/material/card';
import { MatIconModule } from '@angular/material/icon';
import { toObservable } from '@angular/core/rxjs-interop';

@Component({
  selector: 'app-manage-capa-root-cause-methodology',
  imports: [
    ReactiveFormsModule,
    MatDialogModule,
    TextEditorComponent,
    TranslateModule,
    MatButtonModule,
    MatCardModule,
    MatIconModule
  ],
  templateUrl: './manage-capa-root-cause-methodology.component.html',
  styleUrl: './manage-capa-root-cause-methodology.component.scss'
})
export class ManageCapaRootCauseMethodologyComponent implements OnInit {
  capaRootCauseMethodologyForm: FormGroup;
  fb = inject(FormBuilder);
  capaRootCauseMethodologyStore = inject(CapaRootCauseMethodologyStore);
  dialogRef = inject(MatDialogRef<ManageCapaRootCauseMethodologyComponent>);
  isEditMode = false;

  constructor(
    @Inject(MAT_DIALOG_DATA) public methodologyDetail: CapaRootCauseMethodology,
  ) {
    this.subscribeIsAddorUpdate();
  }

  ngOnInit(): void {
    this.createCapaRootCauseMethodologyForm();
    if (this.methodologyDetail) {
      this.isEditMode = true;
      this.capaRootCauseMethodologyForm.patchValue(this.methodologyDetail);
    } else {
      this.isEditMode = false;
    }
  }

  createCapaRootCauseMethodologyForm() {
    this.capaRootCauseMethodologyForm = this.fb.group({
      id: [''],
      name: ['', Validators.required],
      description: [''],
    });
  }

  saveCapaRootCauseMethodology() {
    if (!this.capaRootCauseMethodologyForm.valid) {
      this.capaRootCauseMethodologyForm.markAllAsTouched();
      return;
    }

    const capaRootCauseMethodology = this.capaRootCauseMethodologyForm.getRawValue();

    if (this.isEditMode) {
      this.capaRootCauseMethodologyStore.addUpdateCapaRootCauseMethodology(capaRootCauseMethodology);
    } else {
      this.capaRootCauseMethodologyStore.addUpdateCapaRootCauseMethodology(capaRootCauseMethodology);
    }
  }
  
  subscribeIsAddorUpdate() {
    toObservable(this.capaRootCauseMethodologyStore.isAddUpdate).subscribe((flag) => {
      if (flag) {
        this.onNoClick(this.capaRootCauseMethodologyStore.capaRootCauseMethodology());
      }
      this.capaRootCauseMethodologyStore.resetflag();
    });
  }

  onNoClick(capaRootCauseMethodology?: CapaRootCauseMethodology | null): void {
    this.dialogRef.close(capaRootCauseMethodology);
  }
}

