import { Component, inject, Input, OnChanges, OnInit, SimpleChanges } from '@angular/core';
import { BaseComponent } from '../../../base.component';
import { CapaRootCause } from '../../model/capa-root-cause';
import { CapaRootCauseService } from '../capa-root-cause.service';
import { MatTableModule } from '@angular/material/table';
import { TranslationService } from '@core/services/translation.service';

import { ToastrService } from '@core/services/toastr-service';
import { MatDialog } from '@angular/material/dialog';
import { ManageCapaRootCauseComponent } from '../manage-capa-root-cause/manage-capa-root-cause.component';
import { ActivatedRoute } from '@angular/router';
import { TranslateModule } from '@ngx-translate/core';
import { UTCToLocalTime } from '@shared/pipes/utc-to-localtime.pipe';
import { MatIconModule } from '@angular/material/icon';
import { MatCardModule } from '@angular/material/card';
import { NgClass } from '@angular/common';
import { MatButtonModule } from '@angular/material/button';

@Component({
  selector: 'app-capa-root-cause-list',
  standalone: true,
  imports: [
    MatTableModule,
    MatIconModule,
    TranslateModule,
    UTCToLocalTime,
    MatCardModule,
    NgClass,
    MatButtonModule
  ],
  templateUrl: './capa-root-cause-list.component.html',
  styleUrl: './capa-root-cause-list.component.css'
})
export class CapaRootCauseListComponent extends BaseComponent implements OnInit, OnChanges {
  @Input() capaRootCauseResponse: CapaRootCause | null = null;

  displayedColumns: string[] = ['action', 'createdBy', 'methodologyId', 'createdDate'];
  capaRootCauseList: CapaRootCause[] = [];
  capaRootCauseService = inject(CapaRootCauseService);
  toastrService = inject(ToastrService);
  dialog = inject(MatDialog);
  route = inject(ActivatedRoute);

  ngOnInit(): void {
    this.route.parent?.params.subscribe(params => {
      const capaRequestId = params['id'];
      if (capaRequestId) {
        this.getAllRootCause(capaRequestId);
      }
    });
  }

  ngOnChanges(changes: SimpleChanges): void {
    if (changes['capaRootCauseResponse'] && this.capaRootCauseResponse) {
      if (this.capaRootCauseResponse.id) {
        this.capaRootCauseList = [...this.capaRootCauseList, this.capaRootCauseResponse];
      }
    }
  }

  getAllRootCause(capaRequestId: string) {
    this.sub$.sink = this.capaRootCauseService.getCapaRootCausesById(capaRequestId).subscribe({
      next: (reviews) => {
        const capaRootCause = reviews as CapaRootCause[];
        if (capaRootCause) {
          this.capaRootCauseList = capaRootCause
        }
      },
      error: (error) => {
        this.toastrService.error(this.translationService.getValue(error));
      }
    });
  }

  viewCapaRootCause(capaRootCause: CapaRootCause) {
    this.dialog.open(ManageCapaRootCauseComponent, {
      maxWidth: '60vw',
      width: '100%',
      data: { capaRootCause, isViewOnly: true },
    });
  }

  isOddDataRow(index: number): boolean {
    // index = the index in dataSource, not in DOM
    return index % 2 !== 0;
  }

  getDataIndex(row: any) {
    return this.capaRootCauseList.indexOf(row);
  }
}
