import { inject, Injectable } from '@angular/core';
import { CommonError } from '@core/error-handler/common-error';
import { CommonHttpErrorService } from '@core/error-handler/common-http-error.service';
import { Observable, catchError } from 'rxjs';
import { HttpClient } from '@angular/common/http';
import { CapaRootCause } from '../model/capa-root-cause';

@Injectable({
  providedIn: 'root'
})

export class CapaRootCauseService {
  private httpClient = inject(HttpClient);
  private commonHttpErrorService = inject(CommonHttpErrorService);
  constructor() { }

  getCapaRootCausesById(rootCauseId: string): Observable<CapaRootCause[] | CommonError> {
    const url = `CapaRootCause/${rootCauseId}`;
    return this.httpClient
      .get<CapaRootCause[]>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }

  createCapaRootCause(capaRootCause: CapaRootCause): Observable<CapaRootCause> {
    const url = 'CapaRootCause';
    return this.httpClient
      .post<CapaRootCause>(url, capaRootCause);

  }

  deleteCapaRootCause(rootCauseId: string): Observable<CapaRootCause | CommonError> {
    const url = `CapaRootCause/${rootCauseId}`;
    return this.httpClient
      .delete<CapaRootCause>(url)
      .pipe(catchError(this.commonHttpErrorService.handleError));
  }
}
