import { Routes } from '@angular/router';
import { CapaDetailsComponent } from './capa-details/capa-details.component';
import { AuthGuard } from '@core/security/auth.guard';
import { CapaRequestResolver } from './capa-request/capa-request.resolver';

export const CAPA_ROUTES: Routes = [
  {
    path: 'request/manage',
    canMatch: [AuthGuard],
    data: { claimType: 'ADD_CAPA_REQUEST' },
    loadComponent: () =>
      import(
        './capa-request/manage-capa-request/manage-capa-request.component'
      ).then((c) => c.ManageCapaRequestComponent),
  },
  {
    path: 'requests',
    canMatch: [AuthGuard],
    data: { claimType: 'VIEW_CAPA_REQUEST' },
    loadComponent: () =>
      import(
        './capa-request/capa-request-list/capa-request-list.component'
      ).then((c) => c.CapaRequestListComponent),
  },
  {
    path: 'request/logs',
    canMatch: [AuthGuard],
    data: { claimType: 'MANAGE_CAPA_REQUEST_LOGS' },
    loadComponent: () =>
      import(
        './capa-request-log-list//capa-request-log-list.component'
      ).then((c) => c.CapaRequestLogListComponent),
  },
  {
    path: 'request/manage/:id',
    canMatch: [AuthGuard],
    data: { claimType: 'EDIT_CAPA_REQUEST' },
    loadComponent: () =>
      import(
        './capa-request/manage-capa-request/manage-capa-request.component'
      ).then((c) => c.ManageCapaRequestComponent),
    resolve: {
      capaRequestDetail: CapaRequestResolver,
    },
  },
  {
    path: 'root-cause-methodology',
    canMatch: [AuthGuard],
    data: { claimType: 'VIEW_CAPA_ROOT_CAUSE_METHODOLOGY' },
    loadComponent: () =>
      import(
        './capa-root-cause-methodology/capa-root-cause-methodology-list/capa-root-cause-methodology-list.component'
      ).then((c) => c.CapaRootCauseMethodologyListComponent),
  },
  {
    path: 'root-cause-methodology/manage',
    canMatch: [AuthGuard],
    data: {
      claimType: [
        'ADD_CAPA_ROOT_CAUSE_METHODOLOGY',
      ],
    },
    loadComponent: () =>
      import(
        './capa-root-cause-methodology/manage-capa-root-cause-methodology/manage-capa-root-cause-methodology.component'
      ).then((m) => m.ManageCapaRootCauseMethodologyComponent),
  },
  {
    path: 'root-cause-methodology/manage/:id',
    canMatch: [AuthGuard],
    data: {
      claimType: [
        'EDIT_CAPA_ROOT_CAUSE_METHODOLOGY',
      ],
    },
    loadComponent: () =>
      import(
        './capa-root-cause-methodology/manage-capa-root-cause-methodology/manage-capa-root-cause-methodology.component'
      ).then((m) => m.ManageCapaRootCauseMethodologyComponent),
  },
  {
    path: 'actions',
    canMatch: [AuthGuard],
    data: { claimType: 'VIEW_CAPA_ACTIONS' },
    loadComponent: () =>
      import(
        './capa-action/my-capa-action-list/my-capa-action-list'
      ).then((c) => c.MyCapaActionList),
  },
  {
    path: 'details/:id',
    component: CapaDetailsComponent,
    children: [
      {
        path: '',
        canMatch: [AuthGuard],
        data: { claimType: 'DETAILS_CAPA_REQUEST' },
        loadComponent: () =>
          import(
            './capa-request/manage-capa-request/manage-capa-request.component'
          ).then((c) => c.ManageCapaRequestComponent),
        resolve: {
          capaRequestDetail: CapaRequestResolver,
        },
      },
      {
        path: 'review',
        canMatch: [AuthGuard],
        data: { claimType: ['VIEW_CAPA_REVIEW', 'ADD_CAPA_REVIEW'] },
        loadComponent: () =>
          import(
            './capa-review/manage-capa-review/manage-capa-review.component'
          ).then((c) => c.ManageCapaReviewComponent),
      },
      {
        path: 'root/cause',
        canMatch: [AuthGuard],
        data: { claimType: ['VIEW_CAPA_ROOT_CAUSE', 'ADD_CAPA_ROOT_CAUSE'] },
        loadComponent: () =>
          import(
            './capa-root-cause/manage-capa-root-cause/manage-capa-root-cause.component'
          ).then((c) => c.ManageCapaRootCauseComponent),
      },
      {
        path: 'action',
        canMatch: [AuthGuard],
        data: { claimType: ['VIEW_CAPA_ACTION', 'ADD_CAPA_ACTION'] },
        loadComponent: () =>
          import(
            './capa-action/manage-capa-action/manage-capa-action.component'
          ).then((c) => c.ManageCapaActionComponent),
      },
      {
        path: 'attachment',
        canMatch: [AuthGuard],
        data: { claimType: ['VIEW_CAPA_ATTACHMENT', 'ADD_CAPA_ATTACHMENT'] },
        loadComponent: () =>
          import(
            './capa-attachment/manage-capa-attachment/manage-capa-attachment.component'
          ).then((c) => c.ManageCapaAttachmentComponent),
      },


    ]
  }
];
