import { Pipe, PipeTransform } from '@angular/core';
import { CAPA_ACTION_STATUS } from '../model/capa-action-status-enum';

@Pipe({
  name: 'CapaActionStatus'
})
export class CapaActionStatusPipe implements PipeTransform {

  transform(value: number): string {
    switch (value) {
      case CAPA_ACTION_STATUS.PENDING:
        return 'PENDING';
      case CAPA_ACTION_STATUS.INPROGRESS:
        return 'INPROGRESS';
      case CAPA_ACTION_STATUS.REJECTED:
        return 'REJECTED';
      case CAPA_ACTION_STATUS.COMPLETED:
        return 'COMPLETED';
      default:
        return '';
    }
  }
}
